% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MdeFunc31.R
\name{Koul2StageMde}
\alias{Koul2StageMde}
\title{Two-stage minimum distance estimation in linear regression model with autoregressive error.}
\usage{
Koul2StageMde(
  Y,
  X,
  D,
  b0,
  RegIntMeasure,
  AR_Order,
  ArIntMeasure,
  TuningConst = 1.345
)
}
\arguments{
\item{Y}{- Vector of response variables in linear regression model.}

\item{X}{- Design matrix of explanatory variables in linear regression model.}

\item{D}{- Weight Matrix. Dimension of D should match that of X. Default value is XA where A=(X'X)^(-1/2).}

\item{b0}{- Initial value for beta.}

\item{RegIntMeasure}{- Symmetric and \eqn{\sigma}-finite measure used for estimating \eqn{\beta}: Lebesgue, Degenerate or Robust.}

\item{AR_Order}{- Order of the autoregressive error.}

\item{ArIntMeasure}{- Symmetric and \eqn{\sigma}-finite measure used for estimating autoregressive coefficients of the error: Lebesgue, Degenerate or Robust.}

\item{TuningConst}{- Used only for Robust measure.}
}
\value{
MDE1stage - The list of the first stage minimum distance estimation result. It contains betahat1stage, residual1stage, and rho1stage.
\itemize{
 \item betahat1stage - The first stage minimum distance estimators of regression coefficients.
 \item residual1stage - Residuals after the first stage minimum distance estimation.
 \item rho1stage - The first stage minimum distance estimators of autoregressive coefficients of the error.
}

MDE2stage - The list of the second stage minimum distance estimation result. It contains betahat2stage, residual2stage, and rho2stage.
\itemize{
 \item betahat2stage - The second stage minimum distance estimators of regression coefficients.
 \item residual2stage - Residuals after the second stage minimum distance estimation.
 \item rho2stage - The second stage minimum distance estimators of autoregressive coefficients of the error.
}
}
\description{
Estimates both regression and autoregressive coefficients in the model \eqn{Y=X\beta + \epsilon} where \eqn{\epsilon} is autoregressive process of known order \code{q}
}
\examples{
####################
n <- 10
p <- 3
X <- matrix(runif(n*p, 0,50), nrow=n, ncol=p)  #### Generate n-by-p design matrix X
beta <- c(-2, 0.3, 1.5)                        #### Generate true beta = (-2, 0.3, 1.5)'
rho  <- 0.4                                    #### True rho = 0.4
eps <- vector(length=n)
xi <- rnorm(n, 0,1)                            #### Generate innovation from N(0,1)
                                              #### Generate autoregressive process of order 1
for(i in 1:n){
 if(i==1){eps[i] <- xi[i]}
 else{eps[i] <- rho*eps[i-1] + xi[i]}
}
Y <- X\%*\%beta + eps
#####################
D <- "default"                                  #### Use the default weight matrix
b0 <- solve(t(X)\%*\%X)\%*\%(t(X)\%*\%Y)              #### Set initial value for beta

IntMeasure <- "Lebesgue"                                ##### Define Lebesgue measure
MDEResult <- Koul2StageMde(Y,X, "default", b0, IntMeasure, 1, IntMeasure, TuningConst = 1.345)
MDE1stageResult <- MDEResult[[1]]
MDE2stageResult <- MDEResult[[2]]

beta1 <- MDE1stageResult$betahat1stage
residual1 <- MDE1stageResult$residual1stage
rho1 <- MDE1stageResult$rhohat1stage

beta2 <- MDE2stageResult$betahat2stage
residual2 <- MDE1stageResult$residual2stage
rho2 <- MDE2stageResult$rhohat2stage
}
\references{
[1] Kim, J. (2018). A fast algorithm for the coordinate-wise minimum distance estimation. J. Stat. Comput. Simul., 3: 482 - 497

[2] Koul, H. L (1985). Minimum distance estimation in linear regression with unknown error distributions. Statist. Probab. Lett., 3: 1-8.

[3] Koul, H. L (1986). Minimum distance estimation and goodness-of-fit tests in first-order autoregression. Ann. Statist., 14 1194-1213.

[4] Koul, H. L (2002). Weighted empirical process in nonlinear dynamic models. Springer, Berlin, Vol. 166
}
\seealso{
KoulArMde() and KoulLrMde()
}
