% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single-attribute-value-functions.R
\name{SAVF_score}
\alias{SAVF_score}
\title{Single attribute value function}
\usage{
SAVF_score(x, x_low, x_high, rho)
}
\arguments{
\item{x}{Numeric vector of values to score}

\item{x_low}{Lower bound anchor point (can be different than \code{min(x)})}

\item{x_high}{Upper bound anchor point (can be different than \code{max(x)})}

\item{rho}{Exponential constant for the value function}
}
\value{
A vector of the same length as \code{x} with the exponential single attribute value scores
}
\description{
\code{SAVF_score} computes the exponential single attribute value score of \code{x}
}
\examples{

# The single attribute x is bounded between 1 and 5 and follows an exponential
# utility curve with rho = .653

x <- runif(10, 1, 5)
x
## [1] 2.964853 1.963182 1.223949 1.562025 4.381467 2.286030 3.071066
## [8] 4.470875 3.920913 4.314907

SAVF_score(x, x_low = 1, x_high = 5, rho = .653)
## [1] 0.7800556 0.5038275 0.1468234 0.3315217 0.9605856 0.6131944 0.8001003
## [8] 0.9673124 0.9189685 0.9553165

}
\seealso{
\code{\link{SAVF_plot}} for plotting single attribute scores

\code{\link{SAVF_preferred_rho}} for identifying the preferred rho
}

