% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l2e_regression_convex.R
\name{l2e_regression_convex}
\alias{l2e_regression_convex}
\title{LTE convex regression}
\usage{
l2e_regression_convex(y, b, tau, max_iter = 100, tol = 1e-04)
}
\arguments{
\item{y}{response}

\item{b}{initial vector of regression coefficients}

\item{tau}{initial precision estimate}

\item{max_iter}{maximum number of iterations}

\item{tol}{relative tolerance}
}
\value{
Returns a list object containing the estimates for beta (vector) and tau (scalar)
}
\description{
\code{l2e_regression_convex} Performs robust convex regrsesion using the L2 criterion
}
\examples{

set.seed(12345)
n <- 200
tau <- 1
x <- seq(-2, 2, length.out=n)
f <- x^4 + x
y <- f + (1/tau) * rnorm(n)

## Clean data example
plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5)
lines(x, f, col='blue', lwd=3)

tau <- 1
b <- y
sol <- l2e_regression_convex(y,b,tau)

plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5)
lines(x, f, col='blue', lwd=3)
cvx <- fitted(cobs::conreg(y, convex=TRUE))
lines(x, cvx, col='red', lwd=3)
lines(x, sol$beta, col='green', lwd=3)

## Contaminated data example
ix <- 0:9
y[45 + ix] <- 14 + rnorm(10)

plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5)
lines(x, f, col='blue', lwd=3)

tau <- 1
b <- y
sol <- l2e_regression_convex(y, b, tau)

plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5)
lines(x, f, col='blue', lwd=3)
cvx <- fitted(cobs::conreg(y, convex=TRUE))
lines(x, cvx, col='red', lwd=3)
lines(x, sol$beta, col='green', lwd=3)

}
