# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' LBSPR Optimization function for age-based selectivity model
#'
#' Internal optimization function
#'
#' @param starts a vector of starting parameters, relative SL50 (SL50/Linf), deltaSL (SL95-SL50)/Linf, and F/M (in log space)
#' @param x vector of relative ages
#' @param P numeric value indicating proportion of cohort remaining at maximum age
#' @param LMids a vector of the midpoints of the length classes
#' @param LBins a vector of length classes
#' @param LDat a vector of lenght frequencies. Must be same length as LMids
#' @param MK the M/K value
#' @param Linf the Linf value for the population as a hole
#' @param FecB exponent of the length-fecundity relationship
#' @param L50 length at 50 per cent maturity
#' @param L95 length at 95 per cent maturity
#' @param maxsd numeric value - maximum number of standard deviations of length-at-age dist
#' @param CVLinf CV of length-at-age
#' @param Nage number of pseudo age-classes
#' @param usePen logical to use penalty for extreme estimates of selectivity
#' @return negative log-likelihood value
#' @author A. Hordyk
#' @export
LBSPR_NLLabsel <- function(starts, x, P, LMids, LBins, LDat, MK, Linf, FecB, L50, L95, maxsd, CVLinf, Nage, usePen) {
    .Call('_LBSPR_LBSPR_NLLabsel', PACKAGE = 'LBSPR', starts, x, P, LMids, LBins, LDat, MK, Linf, FecB, L50, L95, maxsd, CVLinf, Nage, usePen)
}

#' LBSPR Optimization function for GTG model
#'
#' Internal optimization function
#'
#' @param starts a vector of starting parameters, relative SL50 (SL50/Linf), deltaSL (SL95-SL50)/Linf, and F/M (in log space)
#' @param LMids a vector of the midpoints of the length classes
#' @param LBins a vector of length classes
#' @param LDat a vector of lenght frequencies. Must be same length as LMids
#' @param gtgLinfs a vector of Linfs for the growth-type-groups
#' @param MKMat a matrix of M/K for each GTG and length-class
#' @param MK the M/K value
#' @param Linf the Linf value for the population as a hole
#' @param ngtg the number of growth-type-groups
#' @param recP a vector of recruitment by GTG
#' @param usePen logical to use penalty for extreme estimates of selectivity
#' @return negative log-likelihood value
#' @author A. Hordyk
#' @export
LBSPR_NLLgtg <- function(starts, LMids, LBins, LDat, gtgLinfs, MKMat, MK, Linf, ngtg, recP, usePen) {
    .Call('_LBSPR_LBSPR_NLLgtg', PACKAGE = 'LBSPR', starts, LMids, LBins, LDat, gtgLinfs, MKMat, MK, Linf, ngtg, recP, usePen)
}

