% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDLErrorPropagation&bootstrapVariance.R
\name{LDL_HDLVrnc}
\alias{LDL_HDLVrnc}
\title{Calculate LDL variance when HDL variance changes}
\usage{
LDL_HDLVrnc(dfHDL, CHOL, TG, bootStrpReps = 2000)
}
\arguments{
\item{dfHDL}{A data frame where each column contains a different set of
HDL values of increasing variance as the column index increases.}

\item{CHOL}{A vector or data frame column containing the cholesterol
values to be used for the calculation of the variance of LDL.}

\item{TG}{A vector or data frame column containing the triglyceride
values to be used for the calculation of the variance of LDL.}

\item{bootStrpReps}{(Default=2000) Number of bootstrap iterations
for bootstrap variance calculation.}
}
\value{
The function returns a list with the Error Propagation variance
(ErrPropVrnc) and the bootstrap variance (BootVrnc).
Each list element is a vector of
length equal to the number of columns of the HDL data frame supplied as
argument (dfHDL) and each vector value corresponds to the respective
variance of the corresponding data frame columns.
}
\description{
This function calculates the variance of LDL using two methods:
Error Propagation and Bootstrap when the HDL distribution changes. It uses a
data frame where each column contains a different set of HDL values of
increasing variance as the column index increases.
}
\examples{
\dontrun{
dfHDL = CV_Range(sampleA$HDL, 0, 100, maxRandIter = 4000, plot=FALSE)
LDLHDLVar = LDL_HDLVrnc(dfHDL,sampleA$CHOL,sampleA$TG,bootStrpReps=2000)
}
}
