% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GICcup_chart.R
\name{plot_GICCup_chart}
\alias{plot_GICCup_chart}
\title{Upward CUSUM Control Chart for Gamma Distribution with Guaranteed Performance}
\usage{
plot_GICCup_chart(
  alpha,
  beta,
  beta_ratio,
  H_delta,
  H_plus,
  n_I,
  n_II,
  faseI = NULL,
  faseII = NULL,
  known_alpha
)
}
\arguments{
\item{alpha}{Shape parameter of the Gamma distribution.}

\item{beta}{Scale parameter of the Gamma distribution.}

\item{beta_ratio}{Ratio between beta and its estimation.}

\item{H_delta}{Increment of the upper GIC limit.}

\item{H_plus}{Initial upper limit of the CUSUM chart.}

\item{n_I}{Sample size in Phase I (if \code{faseI} is not provided).}

\item{n_II}{Sample size in Phase II (if \code{faseII} is not provided).}

\item{faseI}{Sample data from Phase I (numeric vector). If \code{NULL}, it is generated with \code{rgamma()}.}

\item{faseII}{Sample data from Phase II (numeric vector). If \code{NULL}, it is generated with \code{rgamma()}.}

\item{known_alpha}{If \code{TRUE}, a known \code{alpha} is used; if \code{FALSE}, it is estimated.}
}
\value{
A plot displaying the evolution of the upward CUSUM statistic, including:
\itemize{
\item The accumulated values of the CUSUM statistic.
\item Control limits with guaranteed performance.
\item A summary of the parameters used in the control chart.
}
}
\description{
This function generates an upward CUSUM control chart for a Gamma distribution, displaying
the evolution of the CUSUM statistic, control limits, and a summary of the parameters.

Based on the approach presented by Madrid‐Alvarez, García‐Díaz, and Tercero‐Gómez (2024), this implementation enables the evaluation and visualization
of the monitored process using a CUSUM chart adapted to Gamma distributions with guaranteed performance.

Specifically, the library incorporates a Monte Carlo model for simulating the control chart behavior,
allowing the Gamma distribution to be estimated in Phase I or using predefined values. Additionally,
it provides a clear graphical representation of the CUSUM statistic's evolution, ensuring proper
calibration and process control.
\subsection{\strong{Recommendations}}{

To check specific values for \code{H_delta} and \code{H_plus}, it is recommended to review the reference article:
Madrid‐Alvarez, H. M., García‐Díaz, J. C., & Tercero‐Gómez, V. G. (2024).
\strong{A CUSUM control chart for gamma distribution with guaranteed performance}. Quality and Reliability Engineering International, 40(3), 1279-1301.
}

\subsection{Features:}{
\itemize{
\item Based on a Monte Carlo model.
\item Estimates the Gamma distribution in Phase I or uses predefined values.
\item Plots the accumulated values of the CUSUM statistic with guaranteed performance.
\item Includes control limits and a summary table.
}
}
}
\examples{
# Option 1: Automatically generate data with defined sample sizes
plot_GICCup_chart(
                  alpha = 1, beta = 1, beta_ratio = 2, H_delta = 0,
                  H_plus = 5.16, n_I = 100, n_II = 200, faseI = NULL,
                  faseII = NULL, known_alpha = TRUE
                  )

# Option 2: Use custom data
phaseI_data <- rgamma(n = 100, shape = 1, scale = 1)
phaseII_data <- rgamma(n = 200, shape = 1, scale = 1)
plot_GICCup_chart(
                  alpha = 1, beta = 1, beta_ratio = 2, H_delta = 2.9693,
                  H_plus = 6.5081, n_I = 100, n_II = 200,
                  faseI = phaseI_data, faseII = phaseII_data,
                  known_alpha = TRUE
                  )
}
