% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WT.R
\name{WT}
\alias{WT}
\title{Williams Transformation}
\usage{
WT(X, baseline = 1)
}
\arguments{
\item{X}{A matrix object. In general, \code{X} stands for the design matrix, e.g. an LHD or a GLP design.}

\item{baseline}{A integer, which defines the minimum value for each column of the matrix. The default is set to be 1.}
}
\value{
If all inputs are logical, then the output will be a matrix whose sizes are the same as input matrix.
}
\description{
\code{WT} returns a matrix after implementing the Williams transformation
}
\examples{
#create a toy LHD with 5 rows and 3 columns
toy=rLHD(n=5,k=3);toy
toy2=toy-1;toy2  #make elements of "toy" become 0,1,2,3,4

#Implementing Williams transformation on both toy and toy2:
#The result shows that "WT" function is able to detect the
#elements of input matrix and make adjustments.
WT(toy)
WT(toy2)

#Change the baseline
WT(toy,baseline=5)
WT(toy,baseline=10)

}
\references{
Williams, E. J. (1949) Experimental designs balanced for the estimation of residual effects of treatments. \emph{Australian Journal of Chemistry}, \strong{2}, 149-168.
}
