% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaxAbsCor.R
\name{MaxAbsCor}
\alias{MaxAbsCor}
\title{Calculate the Maximum Absolute Correlation}
\usage{
MaxAbsCor(X)
}
\arguments{
\item{X}{A matrix object. In general, \code{X} stands for the design matrix.}
}
\value{
If all inputs are logical, then the output will be a positive number indicating maximum absolute correlation.
\code{maximum absolute correlation = max_{ij} |q_{ij}|}
}
\description{
\code{MaxAbsCor} returns the maximum absolute correlation of a matrix
}
\examples{
#create a toy LHD with 5 rows and 3 columns
toy=rLHD(n=5,k=3);toy

#Calculate the maximum absolute correlation of toy
MaxAbsCor(X=toy)

}
\references{
Georgiou, S. D. (2009) Orthogonal Latin hypercube designs from generalized orthogonal designs. \emph{Journal of Statistical Planning and Inference}, \strong{139}, 1530-1540.
}
