% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLMR.R
\name{llm_config}
\alias{llm_config}
\title{Create LLM Configuration}
\usage{
llm_config(
  provider,
  model,
  api_key,
  troubleshooting = FALSE,
  base_url = NULL,
  embedding = NULL,
  ...
)
}
\arguments{
\item{provider}{Provider name (openai, anthropic, groq, together, voyage, gemini, deepseek)}

\item{model}{Model name to use}

\item{api_key}{API key for authentication}

\item{troubleshooting}{Prints out all api calls. USE WITH EXTREME CAUTION as it prints your API key.}

\item{base_url}{Optional base URL override}

\item{embedding}{Logical indicating embedding mode: NULL (default, uses prior defaults), TRUE (force embeddings), FALSE (force generative)}

\item{...}{Additional provider-specific parameters}
}
\value{
Configuration object for use with call_llm()
}
\description{
Create LLM Configuration
}
\examples{
\dontrun{
  cfg <- llm_config(
    provider   = "openai",
    model      = "gpt-4o-mini",
    api_key    = Sys.getenv("OPENAI_API_KEY"),
    temperature = 0.7,
    max_tokens  = 500)

  call_llm(cfg, "Hello!")  # one-shot, bare string
}
}
\seealso{
The main ways to use a config object:
\itemize{
\item \code{\link{call_llm}} for a basic, single API call.
\item \code{\link{call_llm_robust}} for a more reliable single call with retries.
\item \code{\link{chat_session}} for creating an interactive, stateful conversation.
\item \code{\link{llm_fn}} for applying a prompt to a vector or data frame.
\item \code{\link{call_llm_par}} for running large-scale, parallel experiments.
\item \code{\link{get_batched_embeddings}} for generating text embeddings.
}
}
