% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.lmm.R
\name{confint}
\alias{confint}
\alias{confint.lmm}
\title{Statistical Inference for Linear Mixed Model}
\usage{
\method{confint}{lmm}(
  object,
  parm = NULL,
  level = 0.95,
  effects = NULL,
  robust = FALSE,
  null = NULL,
  columns = NULL,
  df = NULL,
  type.information = NULL,
  transform.sigma = NULL,
  transform.k = NULL,
  transform.rho = NULL,
  transform.names = TRUE,
  backtransform = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{lmm} object.}

\item{parm}{Not used. For compatibility with the generic method.}

\item{level}{[numeric,0-1] the confidence level of the confidence intervals.}

\item{effects}{[character] Should the CIs/p-values for all coefficients be output (\code{"all"}),
or only for mean coefficients (\code{"mean"} or \code{"fixed"}),
or only for variance coefficients (\code{"variance"}),
or only for correlation coefficients (\code{"correlation"}).}

\item{robust}{[logical] Should robust standard errors (aka sandwich estimator) be output instead of the model-based standard errors. Not feasible for variance or correlation coefficients estimated by REML.}

\item{null}{[numeric vector] the value of the null hypothesis relative to each coefficient.}

\item{columns}{[character vector] Columns to be output.
Can be any of \code{"estimate"}, \code{"se"}, \code{"statistic"}, \code{"df"}, \code{"null"}, \code{"lower"}, \code{"upper"}, \code{"p.value"}, \code{"partial.R"}.}

\item{df}{[logical] Should a Student's t-distribution be used to model the distribution of the coefficient. Otherwise a normal distribution is used.}

\item{type.information, transform.sigma, transform.k, transform.rho, transform.names}{are passed to the \code{vcov} method. See details section in \code{\link{coef.lmm}}.}

\item{backtransform}{[logical] should the variance/covariance/correlation coefficient be backtransformed?}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
A data.frame containing for each coefficient (in rows): \itemize{
\item column estimate: the estimate.
\item column se: the standard error.
\item column statistic: the test statistic.
\item column df: the degree of freedom.
\item column lower: the lower bound of the confidence interval.
\item column upper: the upper bound of the confidence interval.
\item column null: the null hypothesis.
\item column p.value: the p-value relative to the null hypothesis.
}
}
\description{
Compute confidence intervals (CIs) and p-values for the coefficients of a linear mixed model.
}
\examples{
## simulate data in the long format
set.seed(10)
dL <- sampleRem(100, n.times = 3, format = "long")

## fit Linear Mixed Model
eUN.lmm <- lmm(Y ~ X1 + X2 + X5, repetition = ~visit|id, structure = "UN", data = dL)

## based on a Student's t-distribution with transformation
confint(eUN.lmm)
## based on a Student's t-distribution without transformation
confint(eUN.lmm, transform.sigma = "none", transform.k = "none", transform.rho = "none")
## based on a Normal distribution with transformation
confint(eUN.lmm, df = FALSE)

}
\seealso{
the function \code{anova} to perform inference about linear combinations of coefficients and adjust for multiple comparisons.
}
