% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iid.R
\name{iid.lmm}
\alias{iid.lmm}
\title{Extract the Influence Function From a Linear Mixed Model}
\usage{
\method{iid}{lmm}(
  x,
  effects = "mean",
  robust = TRUE,
  type.information = NULL,
  transform.sigma = NULL,
  transform.k = NULL,
  transform.rho = NULL,
  transform.names = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{lmm} object.}

\item{effects}{[character] Should the variance-covariance matrix for all coefficients be output (\code{"all"}),
or only for coefficients relative to the mean (\code{"mean"} or \code{"fixed"}),
or only for coefficients relative to the variance structure (\code{"variance"}),
or only for coefficients relative to the correlation structure (\code{"correlation"}).}

\item{robust}{[logical] If \code{FALSE} the influence function is rescaled to match the model-based standard errors.
The correlation however will not (necessarily) match the model-based correlation.}

\item{type.information}{[character] Should the expected information be used  (i.e. minus the expected second derivative) or the observed inforamtion (i.e. minus the second derivative).}

\item{transform.sigma}{[character] Transformation used on the variance coefficient for the reference level. One of \code{"none"}, \code{"log"}, \code{"square"}, \code{"logsquare"} - see details.}

\item{transform.k}{[character] Transformation used on the variance coefficients relative to the other levels. One of \code{"none"}, \code{"log"}, \code{"square"}, \code{"logsquare"}, \code{"sd"}, \code{"logsd"}, \code{"var"}, \code{"logvar"} - see details.}

\item{transform.rho}{[character] Transformation used on the correlation coefficients. One of \code{"none"}, \code{"atanh"}, \code{"cov"} - see details.}

\item{transform.names}{[logical] Should the name of the coefficients be updated to reflect the transformation that has been used?}

\item{...}{Not used. For compatibility with the generic method.}
}
\description{
Extract the influence function from a linear mixed model.
}
\keyword{methods}
