% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPtestEM.R
\name{LPtestEM}
\alias{LPtestEM}
\title{ECME-based testing for a Pareto tail}
\usage{
LPtestEM(x, n, muNull, sigmaNull)
}
\arguments{
\item{x}{list: sequence of integers 1,...,K, where K is the mumber of datasets. Set x = 1 in case
of a single dataset.}

\item{n}{sample size.}

\item{muNull}{log-expectation value under the null hypothesis.}

\item{sigmaNull}{log-standard deviation under the null hypothesis.}
}
\value{
A list with the following elements:

LR: observed value of the llr test.
}
\description{
This function draws a bootstrap sample from the null (lognormal) distribution and computes the test for the null hypothesis of
a pure lognormal distribution versus the alternative of a lognormal-Pareto
mixture, where the parameters of the latter are estimated by means of the
ECME algorithm. To be only called from ParallelTestEM.
}
\examples{
n = 100
muNull = mean(log(TN2016))
sigmaNull = sd(log(TN2016))
res = LPtestEM(1,n,muNull,sigmaNull)
}
