% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exponential_tests.R
\name{exponentail_rate_lr_test}
\alias{exponentail_rate_lr_test}
\title{Test the rate of a exponential distribution using the likelihood ratio test.}
\source{
\url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
}
\usage{
exponentail_rate_lr_test(x, rate = 1, alternative = "two.sided")
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{rate}{a number indicating the tested value of rate.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}
}
\value{
An S3 class containing the test statistic, p value and alternative
hypothesis.
}
\description{
Test the rate of a exponential distribution using the likelihood ratio test.
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rexp(100, 1)
exponentail_rate_lr_test(x, 1, "two.sided")

# Null is false
set.seed(1)
x <- rexp(100, 3)
exponentail_rate_lr_test(x, 1, "greater")
}
