% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_kalman.R
\name{LS.kalman}
\alias{LS.kalman}
\title{Kalman filter for locally stationary processes}
\usage{
LS.kalman(
  series,
  start,
  order = c(p = 0, q = 0),
  ar.order = NULL,
  ma.order = NULL,
  sd.order = NULL,
  d.order = NULL,
  include.d = FALSE,
  m = NULL
)
}
\arguments{
\item{series}{(type: numeric) univariate time series.}

\item{start}{(type: numeric) numeric vector, initial values for parameters to
run the model.}

\item{order}{(type: numeric) vector corresponding to \code{ARMA} model
entered.}

\item{ar.order}{(type: numeric) AR polimonial order.}

\item{ma.order}{(type: numeric) MA polimonial order.}

\item{sd.order}{(type: numeric) polinomial order noise scale factor.}

\item{d.order}{(type: numeric) \code{d} polinomial order, where \code{d} is
the \code{ARFIMA} parameter.}

\item{include.d}{(type: numeric) logical argument for \code{ARFIMA} models.
If \code{include.d=FALSE} then the model is an ARMA process.}

\item{m}{(type: numeric) truncation order of the MA infinity process. By
default \eqn{m = 0.25n^{0.8}} where \code{n} the length of \code{series}.}
}
\value{
A list with:
\item{residuals}{standard residuals.}
\item{fitted_values}{model fitted values.}
\item{delta}{variance prediction error.}
}
\description{
This function run the state-space equations for expansion
infinite of moving average in processes LS-ARMA or LS-ARFIMA.
}
\details{
The model fit is done using the Whittle likelihood, while the generation of
innovations is through Kalman Filter.
Details about \code{ar.order, ma.order, sd.order} and \code{d.order} can be
viewed in \code{\link{LS.whittle}}.
}
\examples{
fit_kalman <- LS.kalman(malleco, start(malleco))
}
\references{
For more information on theoretical foundations and estimation methods see
\insertRef{brockwell2002introduction}{LSTS}
\insertRef{palma2007long}{LSTS}
\insertRef{palma2011estimation}{LSTS}
}
