% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_LTFHPlus_input.R
\name{prepare_graph}
\alias{prepare_graph}
\title{Construct graph from register information}
\usage{
prepare_graph(
  .tbl,
  icol,
  fcol,
  mcol,
  thresholds,
  lower_col = "lower",
  upper_col = "upper",
  missingID_patterns = "^0$"
)
}
\arguments{
\item{.tbl}{tibble with columns icol, fcol, mcol. Additional columns will be attributes in the constructed graph.}

\item{icol}{column name of column with proband ids.}

\item{fcol}{column name of column with father ids.}

\item{mcol}{column name of column with mother ids.}

\item{thresholds}{tibble with icol, lower_col and upper_col. Used to assign lower and upper thresholds to individuals in the graph as attributes.}

\item{lower_col}{Column name of column with proband's lower threshold.}

\item{upper_col}{Column name of column with proband's upper threshold.}

\item{missingID_patterns}{string of missing values in the ID columns. Multiple values can be used, but must be separated by "|". Defaults to "^0$".}
}
\value{
An igraph object. A (directed) graph object based on the links provided in .tbl with the lower and upper thresholds stored as attributes.
}
\description{
\code{prepare_graph} constructs a graph based on mother, father, and offspring links.
}
\examples{
fam <- data.frame(
  id = c("pid", "mom", "dad", "pgf"),
  dadcol = c("dad", 0, "pgf", 0),
  momcol = c("mom", 0, 0, 0))

thresholds <- data.frame(
  id = c("pid", "mom", "dad", "pgf"),
  lower = c(-Inf, -Inf, 0.8, 0.7),
  upper = c(0.8, 0.8, 0.8, 0.7))

prepare_graph(fam, icol = "id", fcol = "dadcol", mcol = "momcol", thresholds = thresholds)

}
