% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_lucid.R
\name{summary_lucid}
\alias{summary_lucid}
\title{Summarize results for integrative clustering}
\usage{
summary_lucid(x, switch = FALSE, order = NULL)
}
\arguments{
\item{x}{An \code{IntClust} class object}

\item{switch}{An indicator to do label switching or not, the default is FALSE}

\item{order}{A customized order for label switching, a vector with a length of K; the default is NULL, which is a descending order in gamma}
}
\value{
\code{summary_lucid} returns a list containing important outputs from an \code{IntClust} object.
\item{Beta}{Estimates of genetic effects, matrix}
\item{Mu}{Estimates of cluster-specific biomarker means, matrix}
\item{Gamma}{Estimates of cluster-specific disease risk, vector}
\item{select_G}{A logical vector indicates non-zero genetic features}
\item{select_Z}{A logical vector indicates non-zero bio-features}
\item{No0G}{A total # of non-zero genetic features}
\item{No0Z}{A total # of non-zero bio-features}
\item{BIC}{Model BIC}
}
\description{
\code{summary_lucid} generates a summary for the results of integrative clustering based on an \code{IntClust} object.
}
\examples{
# For a testing dataset with 10 genetic features (5 causal) and 4 biomarkers (2 causal)

# Integrative clustering without feature selection
set.seed(10)
IntClusFit <- est_lucid(G=G1,Z=Z1,Y=Y1,K=2,family="binary",Pred=TRUE)

# Check important model outputs
summary_lucid(IntClusFit)
}
\references{
Peng, C., Conti, D.V., Integrative latent cluster assignment using multi-omics data with phenotypic traits (under preparation).
}
\author{
Cheng Peng, Zhao Yang, David V. Conti
}
