% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDE.R
\name{plotDE}
\alias{plotDE}
\title{Plot Dose-Effect Experiments}
\usage{
plotDE(DEdata, xlab = "Dose", ylab = "Affected  (\%)",
  xlim = range(DEdata$dose, na.rm = TRUE), ylim = c(0, 100), ref = c(0,
  50, 100), ...)
}
\arguments{
\item{DEdata}{A data frame of dose-effect data (typically, the output from
\code{\link{dataprep}}) containing at least five variables:
dose, pfx, log10dose, bitpfx, fxcateg.}

\item{xlab}{A character scalar, the title for the dose (x) axis, default "Dose".}

\item{ylab}{A character scalar, the title for the affected (y) axis,
default "Affected  (\%)".}

\item{xlim}{A numeric vector of length two giving the x coordinate range for
dose, default range(DEdata$dose, na.rm=TRUE).}

\item{ylim}{A numeric vector of length two giving the y coordinate range for
  affected (\%), default c(0.1, 99.9).
Observed effects beyond this range will be plotted at the limits of this
  range using an open symbol.}

\item{ref}{A numeric vector specifying horizontal reference lines to be added
to the plot, default c(0, 50, 100).}

\item{...}{Additional arguments to \code{\link{plot}}.}
}
\description{
Plot dose-effect experiments on the arithmetic scale.
}
\examples{
dose <- c(0.0625, 0.125, 0.25, 0.5, 1)
ntested <- rep(8, 5)
nalive <- c(1, 4, 4, 7, 8)
mydat <- dataprep(dose=dose, ntot=ntested, nfx=nalive)
plotDE(mydat)
}
\seealso{
\code{\link{predLines}}, \code{\link{plotDELP}}, \code{\link{predLinesLP}}
}

