% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_vec_elem.R
\name{replace_vecelements}
\alias{replace_vecelements}
\title{Replace elements in a data.frame or vector of length > 1 by name}
\usage{
replace_vecelements(x, varnms, vals)
}
\arguments{
\item{x}{A vector or data.frame.}

\item{varnms}{Variable names to match: Specify position by name and index.}

\item{vals}{Vector of values to insert at the specified positions.}
}
\value{
The vector or data.frame in x with the elements 'varnms' replaced by
  vals.
}
\description{
Replace elements in a data.frame or vector of length > 1 by name
}
\examples{
soil_materials <- data.frame(ths = rep(0.4,3), alpha = rep(23.1, 3))

varnms = c("soil_materials.ths3", "soil_materials.ths1", "soil_materials.alpha2")
vals = c(0.999, 0.001, 99)
soil_materials
replace_vecelements(soil_materials, varnms, vals)

x <- set_paramLWFB90()[["pdur"]]
varnms <- c("pdur2", "pdur12")
vals <- c(0,10)
x
replace_vecelements(x, varnms, vals)
}
