% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpm.R
\name{tpm}
\alias{tpm}
\title{Build the transition probability matrix from unconstraint parameter vector}
\usage{
tpm(param, byrow = FALSE)
}
\arguments{
\item{param}{Unconstraint parameter vector of length N*(N-1) where N is the number of states of the Markov chain}

\item{byrow}{Logical that indicates if the transition probability matrix should be filled by row. 
Defaults to FALSE, but should be set to TRUE if one wants to work with a matrix of beta parameters returned by popular HMM packages like moveHMM, momentuHMM, or hmmTMB.}
}
\value{
Transition probability matrix of dimension c(N,N)
}
\description{
This function builds the transition probability matrix from an unconstraint parameter vector. 
For each row of the matrix, the inverse multinomial logistic link is applied.
}
\examples{
# 2 states: 2 free off-diagonal elements
param1 = rep(-1, 2)
Gamma1 = tpm(param1)

# 3 states: 6 free off-diagonal elements
param2 = rep(-2, 6)
Gamma2 = tpm(param2)
}
