% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoding_functions.R
\name{viterbi_p}
\alias{viterbi_p}
\title{Viterbi algorithm for state decoding in periodically inhomogeneous HMMs}
\usage{
viterbi_p(delta, Gamma, allprobs, tod, trackID = NULL, mod = NULL)
}
\arguments{
\item{delta}{initial distribution of length N, or matrix of dimension c(k,N) for k independent tracks, if \code{trackID} is provided

This could e.g. be the periodically stationary distribution (for each track).}

\item{Gamma}{array of transition probability matrices for each time point in the cycle of dimension c(N,N,L), where L is the length of the cycle}

\item{allprobs}{matrix of state-dependent probabilities/ density values of dimension c(n, N)}

\item{tod}{(Integer valued) variable for cycle indexing in 1, ..., L, mapping the data index to a generalised time of day (length n)

For half-hourly data L = 48. It could, however, also be day of year for daily data and L = 365.}

\item{trackID}{optional vector of k track IDs, if multiple tracks need to be decoded separately}

\item{mod}{optional model object containing initial distribution \code{delta}, transition probability matrix \code{Gamma}, matrix of state-dependent probabilities \code{allprobs}, and potentially a \code{trackID} variable

If you are using automatic differentiation either with \code{RTMB::MakeADFun} or \code{\link{qreml}} and include \code{\link{forward_p}} in your likelihood function, the objects needed for state decoding are automatically reported after model fitting.
Hence, you can pass the model object obtained from running \code{RTMB::report()} or from \code{\link{qreml}} directly to this function.}
}
\value{
vector of decoded states of length n
}
\description{
The Viterbi algorithm allows one to decode the most probable state sequence of an HMM.
}
\examples{
delta = c(0.5, 0.5)
beta = matrix(c(-2, 1, -1,
                -2, -1, 1), nrow = 2, byrow = TRUE)
Gamma = tpm_p(1:24, 24, beta)

tod = rep(1:24, 10)
n = length(tod)

allprobs = matrix(runif(2*n), nrow = n, ncol = 2)
states = viterbi_p(delta, Gamma, allprobs, tod)
}
\seealso{
Other decoding functions: 
\code{\link{stateprobs}()},
\code{\link{stateprobs_g}()},
\code{\link{stateprobs_p}()},
\code{\link{viterbi}()},
\code{\link{viterbi_g}()}
}
\concept{decoding functions}
