% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationary_functions.R
\name{stationary_p}
\alias{stationary_p}
\title{Periodically stationary distribution of a periodically inhomogeneous Markov chain}
\usage{
stationary_p(Gamma, t = NULL, ad = NULL)
}
\arguments{
\item{Gamma}{array of transition probability matrices of dimension c(N,N,L)}

\item{t}{integer index of the time point in the cycle, for which to calculate the stationary distribution

If \code{t} is not provided, the function calculates all stationary distributions for each time point in the cycle.}

\item{ad}{optional logical, indicating whether automatic differentiation with \code{RTMB} should be used. By default, the function determines this itself.}
}
\value{
either the periodically stationary distribution at time t or all periodically stationary distributions.
}
\description{
Computes the periodically stationary distribution of a periodically inhomogeneous Markov chain.
}
\details{
If the transition probability matrix of an inhomogeneous Markov chain varies only periodically (with period length \eqn{L}), it converges to a so-called periodically stationary distribution. 
This happens, because the thinned Markov chain, which has a full cycle as each time step, has homogeneous transition probability matrix
\deqn{\Gamma_t = \Gamma^{(t)} \Gamma^{(t+1)} \dots \Gamma^{(t+L-1)}} for all \eqn{t = 1, \dots, L.}
The stationary distribution for time \eqn{t} satifies \eqn{\delta^{(t)} \Gamma_t = \delta^{(t)}}.

This function calculates said periodically stationary distribution.
}
\examples{
# setting parameters for trigonometric link
beta = matrix(c(-1, 2, -1, -2, 1, -1), nrow = 2, byrow = TRUE)
Gamma = tpm_p(beta = beta, degree = 1)
# periodically stationary distribution for specific time point
delta = stationary_p(Gamma, 4)

# all periodically stationary distributions
Delta = stationary_p(Gamma)
}
\references{
Koslik, J. O., Feldmann, C. C., Mews, S., Michels, R., & Langrock, R. (2023). Inference on the state process of periodically inhomogeneous hidden Markov models for animal behavior. arXiv preprint arXiv:2312.14583.
}
\seealso{
\code{\link{tpm_p}} and \code{\link{tpm_g}} to create multiple transition matrices based on a cyclic variable or design matrix

Other stationary distribution functions: 
\code{\link{stationary}()},
\code{\link{stationary_cont}()}
}
\concept{stationary distribution functions}
