% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationary_functions.R
\name{stationary_sparse}
\alias{stationary_sparse}
\title{Sparse version of \code{\link{stationary}}}
\usage{
stationary_sparse(Gamma)
}
\arguments{
\item{Gamma}{sparse transition probability matrix of dimension c(N,N)}
}
\value{
stationary distribution of the Markov chain with the given transition probability matrix
}
\description{
This is function computes the stationary distribution of a Markov chain with a given \strong{sparse} transition probability matrix.
Compatible with automatic differentiation by \code{RTMB}
}
\examples{
## HSMM example (here the approximating tpm is sparse)
# building the t.p.m. of the embedded Markov chain
omega = matrix(c(0,1,1,0), nrow = 2, byrow = TRUE)
# defining state aggregate sizes
sizes = c(20, 30)
# defining state dwell-time distributions
lambda = c(5, 11)
dm = list(dpois(1:sizes[1]-1, lambda[1]), dpois(1:sizes[2]-1, lambda[2]))
# calculating extended-state-space t.p.m.
Gamma = tpm_hsmm(omega, dm)
delta = stationary_sparse(Gamma)
}
