% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.zeng.R
\name{calc.zeng}
\alias{calc.zeng}
\title{Estimate sensible and latent heat fluxes}
\usage{
calc.zeng(dateTime,Ts,airT,Uz,RH,atm.press,wnd.z,airT.z,RH.z)
}
\arguments{
\item{dateTime}{vector of datetime in POSIXct format}

\item{Ts}{numeric value of surface water temperature, degC}

\item{airT}{numeric value of air temperature, degC}

\item{Uz}{numeric value of wind speed, m/s}

\item{RH}{numeric value of relative humidity, \%}

\item{atm.press}{atmospheric pressure in mb}

\item{wnd.z}{height of wind measurement, m}

\item{airT.z}{height of air temperature measurement, m (optional)}

\item{RH.z}{height of relative humidity measurement, m (optional)}
}
\value{
A data.frame including sensible and latent heat flux estimates, and other variables used in calculating these fluxes.
}
\description{
Returns the sensible and latent heat fluxed based on Zeng et al, 1998'
}
\examples{
dateTime <- as.POSIXct("2013-12-30 23:00")
Ts <- 22.51
airT <- 20
Uz <- 3  
RH <- 90
atm.press <- 1013
wnd.z <- 2
calc.zeng(dateTime,Ts,airT,Uz,RH,atm.press,wnd.z)
}
\references{
Zeng, X., M. Zhao., and Dickinson, R.E. 1998. \emph{Intercomparison of bulk aerodynamic algorithms 
for the computation of sea surface fluxes using TOGA COARE and TAO data}. Journal of Climate 11: 2628-2644.
}
\seealso{
\link{k.read}
}
\author{
R. Iestyn. Woolway
}
\keyword{math}
\keyword{methods}
