% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ks_test_t.R
\name{ks_test_t}
\alias{ks_test_t}
\title{One-sample Kolmogorov-Smirnov test for student-t distribution}
\usage{
ks_test_t(x, param = NULL)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{param}{3-dimensional named vector \code{('location', 'scale', 'df')} 
which parametrizes the student t distribution. Default: \code{param = NULL}, 
in which case it will be estimated from \code{x}.}
}
\value{
A list of class \code{"htest"} containing:
\item{statistic}{the value of the Kolomogorv-Smirnov statistic.}
\item{p.value }{the p-value for the test.} 
\item{alternative }{a character string describing the alternative hypothesis.} 
\item{method}{the character string "One-sample Kolmogorov-Smirnov test
              student-t" plus rounded parameter values.} 
\item{data.name}{a character string giving the name(s) of the data.}
}
\description{
Performs a two-sided KS test for \eqn{H_0: X \sim t_{\nu}} with \eqn{c},
    scale \eqn{s}, and degrees of freedom \eqn{\nu}. If parameters are not
    specified, the MLE given the data will be used (see
    \code{\link[MASS]{fitdistr}}).

For estimated parameters of the t-distribution the p-values are incorrect and
    should be adjusted. See \code{\link[stats]{ks.test}} and the references
    therein (Durbin (1973)).  As a more practical approach consider
    bootstrapping and estimating the p-value empirically.
}
\examples{
set.seed(1021)
beta.true <- c(location = 0, scale = 1, df = 4)
xx <- rt(n = 1000, df = beta.true['df'])
ks_test_t(xx)
ks_test_t(xx, beta.true)

}
\seealso{
\code{\link[MASS]{fitdistr}}, \code{\link[stats]{ks.test}}
}
\keyword{htest}
