% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findim_hcpc.R
\name{findim_hcpc}
\alias{findim_hcpc}
\title{Discovering Dimension}
\usage{
findim_hcpc(data, verbose, probit)
}
\arguments{
\item{data}{A binary matrix or dataframe that holds the response data with N individuals (columns) and P items (rows).}

\item{verbose}{a boolean, if TRUE all procedures are descibed in console. The adjusted eigen values are allways shown.}

\item{probit}{a boolean, if FALSE correction of probit to logit model is made (multiplying by 1.702 de discrimination vectors).}
}
\value{
L_data_Clust: list of matrices formed by clusters, each matrix has an associated set of binary vectors of items.

M_data: matrix of the join of objects in L_data_Clust.

dim_new: numeric, Dimension found by the algorithm.

dim_old: numeric, Initial Dimension of the algorithm (set by parallel analysis).

sc: vector, The size of each cluster of L_data_Clust.
}
\description{
Finds the test dimension for a dichotomous logistic model by using Loadings and Factorial Analysis, according to the Paez & Montenegro methodology.
}
\details{
Implementation of a tecnique to evaluate the number of latent constructs presented by data.
}
\examples{
\dontrun{
file = paste(system.file(package = "LatentREGpp"),"/dataset/TUN.txt",sep = "")
TUN = data.matrix(read.table(file))
findim_hcpc(TUN)
findim_hcpc(TUN, verbose = T)
}
}
\references{
Paez S. Montenegro A. and Pardo C. (2017). Principles and Methodology to Find Dimension on Latent Regression Models. Novel based approach.
British Journal of Mathematical and Statistical Psychology. (Submitted)

John L. Horn (1965). A rationale and test for the number of factors 
in factor analysis. Psychometrika, Volume 30, Number 2, Page 179.

Lebart L, Morineau A, Piron M (1997). Statistique Exploratoire Multidimensionnelle. Dunod.

Reckase M (2009). Multidimensional item response theory. Springer.
}
\seealso{
\code{\link{itemfit}}
}

