% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GENLindley.R
\name{GENLindley}
\alias{GENLindley}
\alias{dgenlindley}
\alias{hgenlindley}
\alias{pgenlindley}
\alias{qgenlindley}
\alias{rgenlindley}
\title{Generalized Lindley Distribution}
\source{
[d-h-p-q-r]genlindley are calculated directly from the definitions. \code{rgenlindley} uses either a two-component mixture of the gamma distributions or the quantile function.
}
\usage{
dgenlindley(x, theta, alpha, beta, log = FALSE)

pgenlindley(q, theta, alpha, beta, lower.tail = TRUE, log.p = FALSE)

qgenlindley(p, theta, alpha, beta, lower.tail = TRUE, log.p = FALSE,
  L = 1e-04, U = 50)

rgenlindley(n, theta, alpha, beta, mixture = TRUE, L = 1e-04, U = 50)

hgenlindley(x, theta, alpha, beta, log = FALSE)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{theta, alpha, beta}{positive parameters.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{L, U}{interval which \code{uniroot} searches for a root (quantile), L = 1e-4 and U = 50 are the default values.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{mixture}{logical; If TRUE, (default), random deviates are generated from a two-component mixture of gamma distributions, otherwise from the quantile function.}
}
\value{
\code{dgenlindley} gives the density, \code{pgenlindley} gives the distribution function, \code{qgenlindley} gives the quantile function, \code{rgenlindley} generates random deviates and \code{hgenlindley} gives the hazard rate function.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function, random number generation and hazard rate function for the generalized Lindley distribution with parameters theta, alpha and beta.
}
\details{
Probability density function
\deqn{f( x\mid \theta,\alpha,\beta) =\frac{\theta ^{\alpha +1}}{\left( \theta +\beta \right) \Gamma \left( \alpha +1\right) }x^{\alpha	-1}\left( \alpha +\beta x\right) e^{-\theta x}}

Cumulative distribution function
\deqn{F(x\mid \theta,\alpha,\beta )=\sum_{j=0}^{1}\left\vert j-\frac{\theta }{\left( \theta +\beta \right) }\right\vert \frac{\Gamma \left( \alpha -j,\theta x\right) }{\Gamma \left( \alpha -j\right) }}%

Quantile function
\deqn{\code{does not have a closed mathematical expression}}

Hazard rate function
\deqn{h(x\mid \theta,\alpha,\beta )=\frac{\theta ^{\alpha +1}x^{\alpha -1}\left(\alpha +\beta x\right) e^{-\theta x}}{\left( \theta +\beta \right) \Gamma   \left( \alpha +1\right) \sum\limits_{j=0}^{1}\left\vert j-\frac{\theta }{    \left( \theta +\beta \right) }\right\vert \frac{\Gamma \left( \alpha -j,\theta x\right) }{\Gamma \left( \alpha -j\right) }}}

where \eqn{\Gamma \left( a,b\right)} is the lower incomplete gamma function.

\bold{Particular cases:} \eqn{(\alpha=1, \beta = 1)} the one-parameter Lindley distribution, \eqn{\alpha=1} the two-parameter Lindley distribution, \eqn{(\alpha=1,\beta=0)} the exponential distribution, \eqn{\beta = 0} the gamma distribution and for \eqn{\beta=\alpha} the weighted Lindley distribution.
}
\note{
The \code{\link[stats]{uniroot}} function with default arguments is used to find out the quantiles.
}
\examples{
set.seed(1)
x <- rgenlindley(n = 1000, theta = 1.5, alpha = 1.5, beta = 1.5, mixture = TRUE)
R <- range(x)
S <- seq(from = R[1], to = R[2], by = 0.1)
plot(S, dgenlindley(S, theta = 1.5, alpha = 1.5, beta = 1.5), xlab = 'x', ylab = 'pdf')
hist(x, prob = TRUE, main = '', add = TRUE)

p <- seq(from = 0.1, to = 0.9, by = 0.1)
q <- quantile(x, prob = p)
pgenlindley(q, theta = 1.5, alpha = 1.5, beta = 1.5, lower.tail = TRUE)
pgenlindley(q, theta = 1.5, alpha = 1.5, beta = 1.5, lower.tail = FALSE)
qgenlindley(p, theta = 1.5, alpha = 1.5, beta = 1.5, lower.tail = TRUE)
qgenlindley(p, theta = 1.5, alpha = 1.5, beta = 1.5, lower.tail = FALSE)

library(fitdistrplus)
fit <- fitdist(x, 'genlindley', start = list(theta = 1.5, alpha = 1.5, beta = 1.5))
plot(fit)

}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}
}
\references{
Zakerzadeh, H., Dolati, A., (2009). Generalized Lindley distribution. \emph{Journal of Mathematical Extension}, \bold{3}, (2), 13–25.
}
\seealso{
\code{\link[lamW]{lambertWm1}}, \code{\link[stats]{uniroot}}.
}

