% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkIntensityRules.R
\name{checkIntensityRules}
\alias{checkIntensityRules}
\title{Check intensity rules}
\usage{
checkIntensityRules(intrules, rates, intrequired, nchains, combinations)
}
\arguments{
\item{intrules}{character vector specifying the fragments to compare. See
details.}

\item{rates}{character vector with the expected rates between fragments given
as a string (i.e. "3/1"). See details.}

\item{intrequired}{logical vector indicating if any of the rules is required.
If not, at least one must be verified to confirm the structure.}

\item{nchains}{number of chains of the targeted lipid class.}

\item{combinations}{output of \link{combineChains}.}
}
\value{
List of logical vectors  with the confirmation for each combination.
}
\description{
Check intensity rules to confirm chains position.
}
\details{
This function will be employed when the targeted lipid class has
more than one chain.

Taking PG subclass as an example, intensities of lysoPG fragments
(informative for sn1) can be employed to confirm the chains structure
(intrules = c("lysopg_sn1/lysopg_sn1")). In this case, the intensity of the
lysoPG resulting from the loss of the FA chain in sn2 is at least 3 times
greater (rates = c("3/1")) than the lysoPG resulting from the loss of the FA
chain in sn1.

For the intrules argument, "/" will be use to separate the fragments related
to each chain (sn1/sn2/etc), and "_" will be use to indicate the list in
which they'll be searched. This will depend on the chain fragments
rules defined previously. Following the example, as we use lysoPG to define
the sn1 position, both fragments will be searched in this list (sn1).

For classes with more than one FA chain, if some intensity rule should be
employed to identify their position but they are no defined yet, use "Unknown".
If it is not necessary because the fragmentation rules are informative enough
to define the position (i.e. sphingolipid species), just leave an empty vector.
}
\examples{
\donttest{
dbs <- assignDB()

candidates <- findCandidates(MS1 = LipidMS::MS1_neg$peaklist,
db = dbs$pgdb, ppm = 10, rt = c(0, 2000), adducts = c("M-H"),
rttol = 10, rawData = MS1_neg$rawScans, coelCutoff = 0.8)

MSMS <- rbind(LipidMS::MSMS1_neg$peaklist, LipidMS::MSMS2_neg$peaklist)
rawData <- rbind(LipidMS::MS1_neg$rawScans, LipidMS::MSMS1_neg$rawScans,
LipidMS::MSMS2_neg$rawScans)
coelfrags <- coelutingFrags(candidates$RT, MSMS, rttol = 10, rawData = rawData,
coelCutoff = 0.8)

sn1 <- chainFrags(coelfrags, chainfrags = c("lysopg_M-H"), ppm = 10,
dbs = dbs)
sn2 <- chainFrags(coelfrags, chainfrags = c("fa_M-H"), ppm = 10, dbs = dbs)

chainsComb <- combineChains(candidates, nchains=2, sn1, sn2)

intConf <- checkIntensityRules(intrules = c("lysopg_sn1/lysopg_sn1"),
rates = c("2/1"), intrequired = c(T), nchains=2, chainsComb, sn1, sn2)
}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
