% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossTables.R
\name{crossTables}
\alias{crossTables}
\title{Cross the original MS1 peaklist with the annotation results}
\usage{
crossTables(MS1, results, ppm = 10, rttol = 10, dbs)
}
\arguments{
\item{MS1}{data frame cointaining all peaks from the full MS function. It
must have three columns: m.z, RT (in seconds) and int (intensity).}

\item{results}{data frame. Output of identification functions.}

\item{ppm}{mass tolerance in ppm.}

\item{rttol}{rt tolerance to match peaks in seconds.}

\item{dbs}{list of data bases required for annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be supplied. See \link{createLipidDB}
and \link{assignDB}.}
}
\value{
Data frame with 6 columns: m.z, RT, int, LipidMS_id, adduct and
confidence level for the annotation. When multiple IDs are proposed for the
same feature, they are sorted based on the annotation level.
}
\description{
Cross the original MS1 peaklist with the annotation results.
}
\examples{
\donttest{
library(LipidMSdata)
results <- idNEG(MS1 = MS1_neg, MSMS1 = MSMS1_neg, MSMS2 = MSMS2_neg)
crossTables(MS1_neg$peaklist, results = results$results,
ppm = 10, rttol = 10)}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
