% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LncFinder.R
\name{compute_pI}
\alias{compute_pI}
\title{Compute Theoretical Isoelectric Point}
\usage{
compute_pI(
  Sequences,
  label = NULL,
  on.ORF = FALSE,
  auto.full = FALSE,
  ambiguous.base = FALSE,
  parallel.cores = 2
)
}
\arguments{
\item{Sequences}{A FASTA file loaded by function  \code{\link[seqinr]{read.fasta}} of
\code{\link[seqinr]{seqinr-package}}.}

\item{label}{Optional. String. Indicate the label of the sequences such as
"NonCoding", "Coding".}

\item{on.ORF}{Logical. If \code{TRUE}, pI will be calculated on
the longest ORF region. NOTE: If \code{TRUE}, the input has to be DNA sequences.
(Default: \code{FALSE})}

\item{auto.full}{Logical. When \code{on.ORF = TRUE} but no ORF can be found,
if \code{auto.full = TRUE},  pI will be calculated on full sequences automatically;
if \code{auto.full} is \code{FALSE}, the sequences that have no ORF will be discarded.
Ignored when \code{on.ORF = FALSE}. (Default: \code{FALSE})}

\item{ambiguous.base}{If \code{TRUE}, ambiguous bases are taken into account when
translating DNA sequences into proteins.}

\item{parallel.cores}{Integer. The number of cores for parallel computation.
By default the number of cores is \code{2}. Users can set as \code{-1} to run
this function with all cores.}
}
\value{
A dataframe.
}
\description{
This function is basically a wrapper for function \code{\link[seqinr]{computePI}}.
This function translate DNA sequence into protein, and compute the theoretical isoelectric point
(pI) of this protein.
}
\details{
This function can compute the pI of DNA sequences. Method CPC2 (Kang et al. 2017) uses this
feature to identify lncRNAs, and this feature is evaluated in the article LncFinder (Han et al. 2018).

Using this function, the theoretical pI can be computed on full sequence or the longest ORF region.
In CPC2, pI is calculated on ORF region.
}
\examples{
\dontrun{
data(demo_DNA.seq)
Sequences <- demo_DNA.seq

pI_res <- compute_pI(Sequences, on.ORF = TRUE, auto.full = FALSE, ambiguous.base = FALSE)
}
}
\author{
HAN Siyu
}
