% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_main.R
\name{LoTTA_sharp_CONT}
\alias{LoTTA_sharp_CONT}
\title{LoTTA_sharp_CONT}
\usage{
LoTTA_sharp_CONT(
  x,
  y,
  c,
  ci = 0.95,
  trimmed = NULL,
  outcome_prior = list(pr = 1e-04, shape = 0.01, scale = 0.01),
  n_min = 25,
  param = c("eff", "a0l", "a1l", "a2l", "a3l", "a0r", "a1r", "a2r", "a3r", "tau1r",
    "tau2r", "tau1l", "tau2l", "kl", "kr"),
  normalize = TRUE,
  n.chains = 4,
  burnin = 10000,
  sample = 5000,
  adapt = 1000,
  inits = NULL,
  method = "parallel",
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{\itemize{
\item is the score data
}}

\item{y}{\itemize{
\item is the continuous outcome data
}}

\item{c}{\itemize{
\item specifies the cutoff point
}}

\item{ci}{\itemize{
\item specifies the probability level 1-alpha for the highest posterior density intervals; default is ci = 0.95
}}

\item{trimmed}{\itemize{
\item takes as a value NULL or a vector of two values. It specifies potential trimming of the data.
If set to NULL no trimming is applied to the data. If a list of two values is provided the data is trimmed
to include data points with the score x in between those values; deafult is trimmed=NULL
}}

\item{outcome_prior}{\itemize{
\item takes as a value a list with elements 'pr' and 'shape', 'scale'. 'pr' specifies precision in the normal priors on the coefficients in the
outcome function. 'shape' and 'scale' specify the shape and scale parameters in the gamma prior on the precision of the error terms; default is list('pr'= 0.0001,'shape'= 0.01,'scale'= 0.01)
}}

\item{n_min}{\itemize{
\item specifies the minimum number of data points to which a cubic part of the outcome function is fit to ensure stability of the sampling procedure; default is n_min=25
}}

\item{param}{\itemize{
\item takes as a value a vector with names of the parameters that are to be sampled; default is the list of all parameters
}}

\item{normalize}{\itemize{
\item specifies if the data is to be normalized. The data is normalized as follows. x_normalized=(x-d)/s, where d=(min(x)+max(x))*0.5 and s=max(x)-min(x). y_normalized=(y-mu)/sd, where mu=mean(y) and sd=sd(y).
The priors inside the model are specified for the normalized data, in extreme cases not normalizing the data may lead to unreliable results; default is normalize=TRUE
}}

\item{n.chains}{\itemize{
\item specifies the number of chains in the MCMC sampler; default is n.chains=4
}}

\item{burnin}{\itemize{
\item specifies the number of burnin iterations without the adaptive iterations; default is burnin=5000
}}

\item{sample}{\itemize{
\item specifies the number of samples per chain; default is samples=5000
}}

\item{adapt}{\itemize{
\item specifies the number of adaptive iterations in the MCMC sampler; default is adapt=1000
}}

\item{inits}{\itemize{
\item initial values for the sampler. By default the initial values are sampled inside the function. To run LoTTA with a method other than "parallel" inits must be set to NA or to a user defined value.
If the user wants to provide its own values please refer to run.jags manual; default inits=NULL
}}

\item{method}{\itemize{
\item set to default as 'parallel', which allows to sample the chains in parallel reducing computation time.
To read more about possible method values type ?run.jags; default method='parallel'
}}

\item{seed}{\itemize{
\item specifies the seed for replicability purposes; default is seed=NULL
}}

\item{...}{\itemize{
\item other arguments of run.jags function. For more details type ?run.jags
}}
}
\value{
The function returns the list with the elements:
\itemize{
\item Effect_estimate: contains a list with MAP estimate and HDI of the treatment effect on the original, unnormalized scale;
\item JAGS_output: contains output of the run.jags function for the normalized data if normalize=TRUE, based on this output mixing of the chains can be assessed;
\item Samples: contains posterior samples of the treatment effect (eff);
\item Normalized_data: contains a list of the normalized data (if normalized=TRUE) and the parameters used to normalize the data (see arg normalize);
\item Priors: contains a list of the outcome prior parameters ;
\item Inits contains the list of initial values  and .RNG.seed value
}
}
\description{
Function that fits LoTTA model to the sharp RD data with continuous outcomes. The data does NOT have to be normalized
beforehand. We recommend NOT to transform the data before imputing it into the function, except for initial trimming which should be done beforehand.
The further trimming for the sensitivity analysis can be done through the function, which ensures that the data is normalized before the trimming.
}
\examples{
# functions to generate the data

ilogit <- function(x) {
  return(1 / (1 + exp(-x)))
}

funB <- function(x) {
  y = x
  x2 = x[x >= 0]
  x1 = x[x < 0]
  y[x < 0] = 1 / (1 + exp(-2 * x1)) - 0.5 + 0.4
  y[x >= 0] = (log(x2 * 2 + 1) - 0.15 * x2^2) * 0.6 - 0.20 + 0.4
  return(y)
}

funB_sample <- function(x) {
  y = funB(x)+ rnorm(length(x), 0, 0.1)
  return(y)
}

## Toy example - for the function check only! ##
# data generation
N=100
set.seed(1234)
x = sort(runif(N, -1, 1))
y = funB_sample(x)
c = 0

# running LoTTA function on sharp RDD with continuous outcomes;
out = LoTTA_sharp_CONT(x, y, c,normalize=FALSE, burnin = 50, sample = 50, adapt = 10,
n.chains=1, seed = NULL,method = 'simple',inits = NA)

## Use case example ##
\donttest{# data generation
  N=500 # try different dataset size
  x = sort(runif(N, -1, 1))
  y = funB_sample(x)
  c = 0
  # plot the data
  plot(x,y)
  # running LoTTA function on sharp RDD with continuous outcomes;
  # cutoff = 0, treatment effect = -0.2
  # remember to check convergence and adjust burnin, sample and adapt if needed
  out = LoTTA_sharp_CONT(x, y, c, burnin = 10000, sample = 5000, adapt = 1000,n.chains=4)
  # print effect estimate:
  out$Effect_estimate
  # print JAGS output to asses convergence (the output is for normalized data)
  out$JAGS_output
  # plot posterior fit
  LoTTA_plot_outcome(out)}
}
