% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_taxonomies.species_binomials.R
\name{get_taxonomies.species_binomials}
\alias{get_taxonomies.species_binomials}
\title{Get NCBI Taxonomies from Species Binomials}
\usage{
get_taxonomies.species_binomials(
  path_to_input_species_binomials,
  path_to_output_local_taxa_list,
  path_to_taxonomy_edits = NA,
  print_taxize_queries = TRUE
)
}
\arguments{
\item{path_to_input_species_binomials}{String specifying path to input species list with common and scientific names. The file should be in CSV format and contain the following fields: 'Common_Name', 'Scientific_Name'. Values in the 'Common_Name' field are optional. Values in the 'Scientific_Name' field are required.}

\item{path_to_output_local_taxa_list}{String specifying path to output species list with added NCBI taxonomies. The output file will be in CSV format.}

\item{path_to_taxonomy_edits}{String specifying path to taxonomy edits file in CSV format. The file must contain the following fields: 'Old_Taxonomy', 'New_Taxonomy', 'Notes'. Old taxonomies are replaced with new taxonomies in the order the records appear in the file. The taxonomic levels in the 'Old_Taxonomy' and 'New_Taxonomy' fields should be delimited by a semi-colon. If no taxonomy edits are desired, then set this variable to \code{NA} (the default).}

\item{print_taxize_queries}{Logical. Whether taxa queries should be printed. The default is \code{TRUE}.}
}
\value{
No return value. Writes an output CSV file with added taxonomies.
}
\description{
Remotely fetches taxonomies from the NCBI taxonomy database for a list of species binomials.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get path to example input species binomials CSV file.
path_to_input_file<-system.file("extdata",
                                "example_species_binomials.csv",
                                 package="LocaTT",
                                 mustWork=TRUE)

# Create a temporary file path for the output CSV file.
path_to_output_file<-tempfile(fileext=".csv")

# Fetch taxonomies from species binomials.
get_taxonomies.species_binomials(path_to_input_species_binomials=path_to_input_file,
                                 path_to_output_local_taxa_list=path_to_output_file,
                                 print_taxize_queries=FALSE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=get_taxonomies.IUCN]{get_taxonomies.IUCN}} for formatting taxonomies from the IUCN Red List.
}
