% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_pairs.R
\name{merge_pairs}
\alias{merge_pairs}
\title{Merge Forward and Reverse DNA Sequence Reads}
\usage{
merge_pairs(forward_reads, reverse_reads, minimum_overlap = 10)
}
\arguments{
\item{forward_reads}{A character vector of forward DNA sequence reads.}

\item{reverse_reads}{A character vector of reverse DNA sequence reads.}

\item{minimum_overlap}{Numeric. The minimum length of an overlap that must be found between the end of the forward read and the start of the reverse complement of the reverse read in order for a read pair to be merged. The default is \code{10}.}
}
\value{
A character vector of merged DNA sequence read pairs. \code{NA}s are returned for read pairs which could not be merged, which occurs when an overlap of at least the minimum length is not found between the end of the forward read and the start of the reverse complement of the reverse read.
}
\description{
Merges forward and reverse DNA sequence reads.
}
\details{
For each pair of forward and reverse DNA sequence reads, the reverse complement of the reverse read is internally derived using the \code{\link[=reverse_complement]{reverse_complement}} function, and the read pair is merged into a single sequence if an overlap of at least the minimum length is found between the end of the forward read and the start of the reverse complement of the reverse read. If an overlap of the minimum length is not found, then an \code{NA} is returned for the merged read pair.
}
\examples{
merge_pairs(forward_reads=c("CCTTACGAATCCTGT","TTCTCCACCCGCGGATA","CGCCCGGAGTCCCTGTAGTA"),
            reverse_reads=c("GACAAACAGGATTCG","CAATATCCGCGGGTG","TACTACAGGGACTCC"))
}
