% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logicopt.R
\name{tt2eqn}
\alias{tt2eqn}
\title{Equations from a Truth Table}
\usage{
tt2eqn(tt, n_in, n_out, QCA = FALSE)
}
\arguments{
\item{tt}{R data frame truth table.}

\item{n_in}{Number of inputs in the tt.}

\item{n_out}{Number of outputs in the tt.}

\item{QCA}{Print in QCA format.}
}
\value{
Vector of equations strings. One for each output.
}
\description{
This function generates the ON set equations for a truth table.
Inputs are uppercase if they are positive and lowercase for negative.
}
\examples{
data(l.small)
tt <- logicopt(l.small,n_in=4,n_out=3)
eqn <- tt2eqn(tt[[1]],4,3)

}

