\name{KMPlot.SurvCART}
\alias{KMPlot.SurvCART}
\title{
KM plot for SurvCART object
}
\description{
Generates KM plot for sub-groups (i.e., terminal nodes) associated with survival tree generated by SurvCART()
}
\usage{
KMPlot.SurvCART(x, scale.time = 1, type = 1, ...)
}
\arguments{
  \item{x}{a fitted object of class \code{"SurvCART"}, containing a survival tree.}
  \item{scale.time}{Divides the time variable by the factor of scale.time. For example, if times are collected in days, then to plot time in years, specify 365.25.}
  \item{type}{1 for KM plot of survival probabilities, 2 for KM plot of censoring probabilities}
  \item{...}{arguments to be passed to or from other methods.}
}
\author{ Madan Gopal Kundu \email{madan_g.kundu@yahoo.com}}

\references{
Kundu, M. G.(2020). Survival trees based on score based parameter instability test. 
}
\seealso{
\code{\link{text.SurvCART}}, \code{\link{plot.SurvCART}}, \code{\link{SurvCART}}, \code{\link{StabCat.surv}}, \code{\link{StabCont.surv}}
}

\examples{
#--- Get the data
data(GBSG2)

#numeric coding of character variables
GBSG2$horTh1<- as.numeric(GBSG2$horTh)
GBSG2$tgrade1<- as.numeric(GBSG2$tgrade)
GBSG2$menostat1<- as.numeric(GBSG2$menostat)

#Add subject id
GBSG2$subjid<- 1:nrow(GBSG2)

#--- Run SurvCART() with time-to-event distribution: exponential, censoring distribution: None  
out<- SurvCART(data=GBSG2, patid="subjid", censorvar="cens", timevar="time", 
        gvars=c('horTh1', 'age', 'menostat1', 'tsize', 'tgrade1', 'pnodes', 'progrec', 'estrec'),  
        tgvars=c(0,1,0,1,0,1, 1,1),          
        event.ind=1,  alpha=0.05, minsplit=80, minbucket=40, print=TRUE)

#--- Plot tree
par(xpd = TRUE)
plot(out, compress = TRUE)
text(out, use.n = TRUE)

#Plot KM plot of survival probabilities for sub-groups identified by tree
KMPlot.SurvCART(out, scale.time=365.25, type=1)

#Plot KM plot of censoring probabilities for sub-groups identified by tree
KMPlot.SurvCART(out, scale.time=365.25, type=1)
}
