% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trans_from_phylo.R
\name{Trans_from_phylo}
\alias{Trans_from_phylo}
\title{Convert phyloseq object to LorMe object}
\usage{
Trans_from_phylo(
  physeq,
  into = "standard",
  outputtax = c("Phylum", "Genus"),
  reads = TRUE
)
}
\arguments{
\item{physeq}{The phyloseq object to convert. See in \code{\link[phyloseq:phyloseq]{phyloseq}} object}

\item{into}{Names of separated taxonomy to create as character vector. Must select from c("Domain","Phylum","Class","Order","Family","Genus","Species").
Shortcut input:1)By default."standard":c("Domain","Phylum","Class","Order","Family","Genus","Species"). Used for standard taxonomy annotation to OTU/ASV table.
2)"complete":c("Domain","Kingdom","Phylum","Class","Order","Family","Genus","Species"). Used for complete taxonomy annotation to meta genomic table.}

\item{outputtax}{Default:c("Phylum","Genus").Names of output taxonomy level table.  Shortcut input is available with 'standard' and 'complete' same as above.}

\item{reads}{Logical.True for reads table and FALSE for percentage table. Default: TRUE}
}
\value{
LorMe object containing taxonomy table data frame,containing reads and percentage table for each specified output.
}
\description{
Convert phyloseq object to LorMe object
}
\note{
For taxonomy annotation with both 'Domain' and 'Kingdom' level, please set 'into' parameter as 'complete'!!!

The taxonomyTable of phyloseq object should contained as least standard annotations for convert!
}
\examples{
## Not run:
\donttest{
if (requireNamespace("phyloseq", quietly = TRUE)) {
 data("GlobalPatterns", package = "phyloseq")

 ## convert phyloseq object to LorMe format
 gp_obj <- Trans_from_phylo(GlobalPatterns, outputtax = "standard")

 ## specify experimental design
 gp_plan <- object_config(gp_obj,
                          treat_location = 6,
                          rep_location   = 7)

 ## generate community-structure PCoA plot (Genus level)
 community_structure <- structure_plot(gp_plan, taxlevel = "Genus")
 community_structure$PCoA_Plot
}
}

}
