% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCADFABS-estimation.R
\name{Lorenz.SCADFABS}
\alias{Lorenz.SCADFABS}
\title{Estimates the parameter vector in a penalized Lorenz regression with SCAD penalty}
\usage{
Lorenz.SCADFABS(
  y,
  x,
  standardize = TRUE,
  weights = NULL,
  kernel = 1,
  h = length(y)^(-1/5.5),
  gamma = 0.05,
  a = 3.7,
  lambda = "Shi",
  eps = 0.005,
  SCAD.nfwd = NULL,
  iter = 10^4,
  lambda.min = 1e-07
)
}
\arguments{
\item{y}{a vector of responses}

\item{x}{a matrix of explanatory variables}

\item{standardize}{Should the variables be standardized before the estimation process? Default value is TRUE.}

\item{weights}{vector of sample weights. By default, each observation is given the same weight.}

\item{kernel}{integer indicating what kernel function to use. The value 1 is the default and implies the use of an Epanechnikov kernel while the value of 2 implies the use of a biweight kernel.}

\item{h}{bandwidth of the kernel, determining the smoothness of the approximation of the indicator function. Default value is n^(-1/5.5) where n is the sample size.}

\item{gamma}{value of the Lagrange multiplier in the loss function}

\item{a}{parameter of the SCAD penalty. Default value is 3.7.}

\item{lambda}{this parameter relates to the regularization parameter. Several options are available.
\describe{
    \item{\code{grid}}{If lambda="grid", lambda is defined on a grid, equidistant in the logarithmic scale.}
    \item{\code{Shi}}{If lambda="Shi", lambda, is defined within the algorithm, as in Shi et al (2018).}
    \item{\code{supplied}}{If the user wants to supply the lambda vector himself}
}}

\item{eps}{step size in the FABS algorithm. Default value is 0.005.}

\item{SCAD.nfwd}{optional tuning parameter used if penalty="SCAD". Default value is NULL. The larger the value of this parameter, the sooner the path produced by the SCAD will differ from the path produced by the LASSO.}

\item{iter}{maximum number of iterations. Default value is 10^4.}

\item{lambda.min}{lower bound of the penalty parameter. Only used if lambda="Shi".}
}
\value{
A list with several components:
\describe{
   \item{\code{lambda}}{vector gathering the different values of the regularization parameter}
   \item{\code{theta}}{matrix where column i provides the vector of estimated coefficients corresponding to the value \code{lambda[i]} of the regularization parameter.}
   \item{\code{LR2}}{vector where element i provides the Lorenz-\eqn{R^2} attached to the value \code{lambda[i]} of the regularization parameter.}
   \item{\code{Gi.expl}}{vector where element i provides the estimated explained Gini coefficient related to the value \code{lambda[i]} of the regularization parameter.}
}
}
\description{
\code{Lorenz.SCADFABS} solves the penalized Lorenz regression with SCAD penalty on a grid of lambda values.
For each value of lambda, the function returns estimates for the vector of parameters and for the estimated explained Gini coefficient, as well as the Lorenz-\eqn{R^2} of the regression.
}
\details{
The regression is solved using the SCAD-FABS algorithm developed by Jacquemain et al and adapted to our case.
For a comprehensive explanation of the Penalized Lorenz Regression, see Heuchenne et al.
In order to ensure identifiability, theta is forced to have a L2-norm equal to one.
}
\section{References}{

Jacquemain, A., C. Heuchenne, and E. Pircalabelu (2024). A penalised bootstrap estimation procedure for the explained Gini coefficient. \emph{Electronic Journal of Statistics 18(1) 247-300}.
}

\examples{
data(Data.Incomes)
y <- Data.Incomes[,1]
x <- as.matrix(Data.Incomes[,-c(1,2)])
Lorenz.SCADFABS(y, x)

}
\seealso{
\code{\link{Lorenz.Reg}}, \code{\link{Lorenz.FABS}}
}
