% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readXSYG2R.R
\name{readXSYG2R}
\alias{readXSYG2R}
\title{Import XSYG files to R}
\usage{
readXSYG2R(file, recalculate.TL.curves = TRUE, fastForward = FALSE,
  import = TRUE, txtProgressBar = TRUE)
}
\arguments{
\item{file}{\link{character} (\bold{required}): path and file name of the
XSYG file.}

\item{recalculate.TL.curves}{\link{logical} (with default): if set to
\code{TRUE}, TL curves are returned as temperature against count values (see
details for more information) Note: The option overwrites the time vs. count
TL curve. Select \code{FALSE} to import the raw data delivered by the
lexsyg. Works for TL curves and spectra.}

\item{fastForward}{\code{\link{logical}} (with default): if \code{TRUE} for a
more efficient data processing only a list of \code{RLum.Analysis} objects is returned.}

\item{import}{\link{logical} (with default): if set to \code{FALSE}, only
the XSYG file structure is shown.}

\item{txtProgressBar}{\link{logical} (with default): enables \code{TRUE} or
disables \code{FALSE} the progression bar during import}
}
\value{
\bold{Using the option \code{import = FALSE}}\cr\cr A list
consisting of two elements is shown: \item{Sample}{\link{data.frame} with
information on file.} \item{Sequences}{\link{data.frame} with information on
the sequences stored in the XSYG file}.\cr\cr \bold{Using the option
\code{import = TRUE} (default)} \cr\cr A list is provided, the list elements
contain: \item{Sequence.Header}{\link{data.frame} with information on the
sequence.} \item{Sequence.Object}{\code{\linkS4class{RLum.Analysis}}
containing the curves.}
}
\description{
Imports XSYG files produced by a Freiberg Instrument lexsyg reader into R.
}
\details{
\bold{How does the import function work?}\cr\cr The function uses the
\code{\link{xml}} package to parse the file structure. Each sequence is
subsequently translated into an \code{\linkS4class{RLum.Analysis}}
object.\cr\cr

\bold{General structure XSYG format}\cr\cr \code{<?xml?}\cr \code{
<Sample>}\cr \code{ <Sequence>}\cr \code{ <Record>}\cr \code{ <Curve
name="first curve" />}\cr \code{ <Curve name="curve with data">}\cr \code{
x0 , y0 ; x1 , y1 ; x2 , y2 ; x3 , y3}\cr \code{ </Curve>}\cr \code{
</Record>}\cr \code{ </Sequence>}\cr \code{ </Sample>}\cr\cr So far, each
XSYG file can only contain one \code{<Sample></Sample>}, but multiple
sequences. \cr\cr Each record may comprise several curves.\cr\cr

\bold{TL curve recalculation}\cr

On the FI lexsyg device TL curves are recorded as time against count values.
Temperature values are monitored on the heating plate and stored in a
separate curve (time vs. temperature). If the option
\code{recalculate.TL.curves = TRUE} is chosen, the time values for each TL
curve are replaced by temperature values.\cr

Practically, this means combining two matrices (Time vs. Counts and Time vs.
Temperature) with different row numbers by their time values. Three cases
are considered:

HE: Heating element\cr PMT: Photomultiplier tube\cr Interpolation is done
using the function \code{\link{approx}}\cr

CASE (1): \code{nrow(matrix(PMT))} > \code{nrow(matrix(HE))} \cr

Missing temperature values from the heating element are calculated using
time values from the PMT measurement.\cr

CASE (2): \code{nrow(matrix(PMT))} < \code{nrow(matrix(HE))} \cr

Missing count values from the PMT are calculated using time values from the
heating element measurement.\cr

CASE (3): \code{nrow(matrix(PMT))} == \code{nrow(matrix(HE))} \cr

A new matrix is produced using temperature values from the heating element
and count values from the PMT. \cr

\emph{Note: Please note that due to the recalculation of the temperature
values based on values delivered by the heating element, it may happen that
mutiple count values exists for each temperature value and temperature
values may also decrease during heating, not only increase. }
}
\note{
This function is a beta version as the XSYG file format is not yet
fully specified. Thus, further file operations (merge, export, write) should
be done using the functions provided with the package \code{\link{xml}}.\cr

\bold{So far, no image data import is provided!}\cr Corresponding values in
the XSXG file are skipped.
}
\section{Function version}{
 0.4.5 (2015-09-21 15:05:38)
}
\examples{
##(1) import XSYG file to R (uncomment for usage)

#FILE <- file.choose()
#temp <- readXSYG2R(FILE)

##(2) additional examples for pure XML import using the package XML
##    (uncomment for usage)

  ##import entire XML file
  #FILE <- file.choose()
  #temp <- XML::xmlRoot(XML::xmlTreeParse(FILE))

  ##search for specific subnodes with curves containing 'OSL'
  #getNodeSet(temp, "//Sample/Sequence/Record[@recordType = 'OSL']/Curve")

##(2) How to extract single curves ... after import
data(ExampleData.XSYG, envir = environment())

##grep one OSL curves and plot the first curve
OSLcurve <- get_RLum(OSL.SARMeasurement$Sequence.Object, recordType="OSL")[[1]]

##(3) How to see the structure of an object?
structure_RLum(OSL.SARMeasurement$Sequence.Object)
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team}
\references{
Grehl, S., Kreutzer, S., Hoehne, M., 2013. Documentation of the
XSYG file format. Unpublished Technical Note. Freiberg, Germany \cr\cr

\bold{Further reading} \cr\cr XML: \url{http://en.wikipedia.org/wiki/XML}
}
\seealso{
\code{\link{xml}}, \code{\linkS4class{RLum.Analysis}},
\code{\linkS4class{RLum.Data.Curve}}, \code{\link{approx}}
}
\keyword{IO}

