% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Data.Curve-class.R
\docType{class}
\name{RLum.Data.Curve-class}
\alias{RLum.Data.Curve-class}
\alias{get_RLum,RLum.Data.Curve-method}
\alias{length_RLum,RLum.Data.Curve-method}
\alias{names_RLum,RLum.Data.Curve-method}
\alias{set_RLum,RLum.Data.Curve-method}
\alias{show,RLum.Data.Curve-method}
\title{Class \code{"RLum.Data.Curve"}}
\usage{
\S4method{show}{RLum.Data.Curve}(object)

\S4method{set_RLum}{RLum.Data.Curve}(class, originator,
  recordType = NA_character_, curveType = NA_character_, data = matrix(0,
  ncol = 2), info = list())

\S4method{get_RLum}{RLum.Data.Curve}(object, info.object)

\S4method{length_RLum}{RLum.Data.Curve}(object)

\S4method{names_RLum}{RLum.Data.Curve}(object)
}
\arguments{
\item{object}{[\code{show_RLum}][\code{get_RLum}][\code{length_RLum}][\code{names_RLum}] an object of
class \code{\linkS4class{RLum.Data.Curve}} (\bold{required})}

\item{class}{[\code{set_RLum}] \code{\link{character}} (\bold{required}): name of the \code{RLum} class to create}

\item{originator}{[\code{set_RLum}] \code{\link{character}} (automatic): contains the name of the calling function
(the function that produces this object); can be set manually.}

\item{recordType}{[\code{set_RLum}] \code{\link{character}} (optional): record type (e.g., "OSL")}

\item{curveType}{[\code{set_RLum}] \code{\link{character}} (optional): curve type (e.g., "predefined" or "measured")}

\item{data}{[\code{set_RLum}] \code{\link{matrix}} (\bold{required}): raw curve data.
If \code{data} itself is a \code{RLum.Data.Curve}-object this can be used to re-construct the object
(s. Details)}

\item{info}{[\code{set_RLum}] \code{\link{list}} (optional): info elements}

\item{info.object}{[\code{get_RLum}] \code{\link{character}} (optional): name of the wanted info
element}
}
\value{
\bold{\code{set_RLum}}\cr

Returns an \code{\linkS4class{RLum.Data.Curve}} object.

\bold{\code{get_RLum}}\cr

(1) A \code{\link{matrix}} with the curve values or \cr
(2) only the info object if \code{info.object} was set.\cr

\bold{\code{length_RLum}}\cr

Number of channels in the curve (row number of the matrix)

\bold{\code{names_RLum}}\cr

Names of the info elements (slot \code{info})
}
\description{
Class for representing luminescence curve data.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Show structure of \code{RLum.Data.Curve} object

\item \code{set_RLum}: Construction method for RLum.Data.Curve object. The slot info is optional
and predefined as empty list by default.

\item \code{get_RLum}: Accessor method for RLum.Data.Curve object. The argument info.object is
optional to directly access the info elements. If no info element name is
provided, the raw curve data (matrix) will be returned.

\item \code{length_RLum}: Returns the length of the curve object, which is the maximum of the
value time/temperature of the curve (corresponding to the stimulation length)

\item \code{names_RLum}: Returns the names info elements coming along with this curve object
}}
\section{Slots}{

\describe{
\item{\code{recordType}}{Object of class "character" containing the type of the curve (e.g. "TL" or "OSL")}

\item{\code{curveType}}{Object of class "character" containing curve type, allowed values are measured or predefined}

\item{\code{data}}{Object of class \code{\link{matrix}} containing curve x and y data.
'data' can also be of type \code{RLum.Data.Curve} to change object values without deconstructing the object.
For example: \code{set_RLum(class = 'RLum.Data.Curve',
data = Your.RLum.Data.Curve, recordType = 'never seen before')}
would just change the recordType. Missing arguements  the value is taken from the input object
in 'data' (which is already an RLum.Data.Curve object in this example)}

\item{\code{info}}{Object of class "list" containing further meta information objects}
}}
\note{
The class should only contain data for a single curve. For additional
elements the slot \code{info} can be used (e.g. providing additional heating
ramp curve). Objects from the class \code{RLum.Data.Curve} are produced by other
functions (partyl within \code{\linkS4class{RLum.Analysis}} objects),
namely: \code{\link{Risoe.BINfileData2RLum.Data.Curve}},
\code{\link{Risoe.BINfileData2RLum.Analysis}}, \code{\link{read_XSYG2R}}
}
\section{Create objects from this Class}{
 Objects can be created by calls of the form
\code{set_RLum(class = "RLum.Data.Curve", ...)}.
}

\section{Class version}{
 0.3.0
}
\examples{

showClass("RLum.Data.Curve")

##set empty curve object
set_RLum(class = "RLum.Data.Curve")

}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
}
\seealso{
\code{\linkS4class{RLum}}, \code{\linkS4class{RLum.Data}},
\code{\link{plot_RLum}}, \code{\link{merge_RLum}}
}
\keyword{classes}

