% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_EfficiencyCorrection.R
\name{apply_EfficiencyCorrection}
\alias{apply_EfficiencyCorrection}
\title{Function to apply spectral efficiency correction to RLum.Data.Spectrum S4
class objects}
\usage{
apply_EfficiencyCorrection(object, spectral.efficiency)
}
\arguments{
\item{object}{\code{\linkS4class{RLum.Data.Spectrum}} (\bold{required}): S4
object of class \code{RLum.Data.Spectrum}}

\item{spectral.efficiency}{\code{\link{data.frame}} (\bold{required}): Data
set containing wavelengths (x-column) and relative spectral response values
(y-column) in percentage}
}
\value{
Returns same object as input
(\code{\linkS4class{RLum.Data.Spectrum}})
}
\description{
The function allows spectral efficiency corrections for RLum.Data.Spectrum
S4 class objects
}
\details{
The efficiency correction is based on a spectral response dataset provided
by the user. Usually the data set for the quantum efficiency is of lower
resolution and values are interpolated for the required spectral resolution.
}
\note{
Please note that the spectral efficiency data from the camera may not
sufficiently correct for spectral efficiency of the entire optical system
(e.g., spectrometer, camera ...).

This function has BETA status.
}
\section{Function version}{
 0.1 (2015-11-29 17:27:48)
}
\examples{


##(1) - use with your own data (uncomment for usage)
## spectral.efficiency <- read.csv("your data")
##
## your.spectrum <- apply_EfficiencyCorrection(your.spectrum, )

}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France),\cr Johannes Friedrich, University of Bayreuth (Germany)
\cr R Luminescence Package Team}
\references{
-
}
\seealso{
\code{\linkS4class{RLum.Data.Spectrum}}
}
\keyword{manip}

