% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\docType{package}
\name{Luminescence-package}
\alias{Luminescence-package}
\alias{Luminescence}
\title{Comprehensive Luminescence Dating Data Analysis}
\description{
A collection of various R functions for the purpose of Luminescence dating
data analysis. This includes, amongst others, data import, export,
application of age models, curve deconvolution, sequence analysis and
plotting of equivalent dose distributions.
}
\details{
\tabular{ll}{ Package: \tab Luminescence\cr Type: \tab Package\cr Version:
\tab 0.7.4 \cr Date: \tab 2017-03-31 \cr License: \tab GPL-3\cr }
}
\references{
Dietze, M., Kreutzer, S., Fuchs, M.C., Burow, C., Fischer, M.,
Schmidt, C., 2013. A practical guide to the R package Luminescence.
Ancient TL, 31, 11-18.

Dietze, M., Kreutzer, S., Burow, C., Fuchs, M.C., Fischer, M., Schmidt, C., 2016. The abanico plot:
visualising chronometric data with individual standard errors. Quaternary Geochronology 31, 1-7.
http://dx.doi.org/10.1016/j.quageo.2015.09.003

Fuchs, M.C., Kreutzer, S., Burow, C., Dietze, M., Fischer, M., Schmidt, C.,
Fuchs, M., 2015. Data processing in luminescence dating analysis: An
exemplary workflow using the R package 'Luminescence'. Quaternary
International, 362,8-13. http://dx.doi.org/10.1016/j.quaint.2014.06.034

Kreutzer, S., Schmidt, C., Fuchs, M.C., Dietze, M., Fischer, M., Fuchs, M.,
2012. Introducing an R package for luminescence dating analysis. Ancient TL,
30, 1-8.

Smedley, R.K., 2015. A new R function for the Internal External Uncertainty (IEU) model.
Ancient TL 33, 16-21.
}
\author{
\bold{Full list of authors and contributors} (alphabetic order)

\tabular{ll}{
Christoph Burow \tab University of Cologne, Germany \cr
Claire Christophe \tab IRAMAT-CRP2A, Universite Bordeaux Montaigne, France \cr
Michael Dietze \tab GFZ Helmholtz Centre Potsdam, Germany \cr
Julie Durcan \tab University of Oxford, United Kingdom \cr
Manfred Fischer\tab University of Bayreuth, Germany \cr
Margret C. Fuchs \tab Helmholtz-Zentrum Dresden-Rossendorf, Helmholtz-Institute Freiberg for Resource Technology,
Freiberg, Germany \cr
Johannes Friedrich \tab University of Bayreuth, Germany \cr
Guillaume Guerin \tab IRAMAT-CRP2A, Universite Bordeaux Montaigne, France \cr
Georgina King \tab Institute of Geological Sciences, University of Bern, Switzerland \cr
Sebastian Kreutzer \tab IRAMAT-CRP2A, Universite Bordeaux Montaigne, France \cr
Norbert Mercier \tab IRAMAT-CRP2A, Universite Bordeaux Montaigne, France \cr
Anne Philippe \tab  Universite de Nantes and ANJA INRIA, Rennes, France \cr
Christoph Schmidt \tab University of Bayreuth, Germany \cr
Rachel K. Smedley \tab Aberystwyth University, United Kingdom \cr
Antoine Zink \tab C2RMF, Palais du Louvre, Paris, France
}

\bold{Supervisor of the initial version in 2012}

Markus Fuchs, Justus-Liebig-University Giessen, Germany\cr

\bold{Support contact}

\email{developers@r-luminescence.org}\cr

We may further encourage the usage of our support forum. For this please
visit our project website (link below).

\bold{Bug reporting}

\email{developers@r-luminescence.org} or \cr
\url{https://github.com/R-Lum/Luminescence/issues} \cr

\bold{Project website}

\url{http://www.r-luminescence.org}\cr

\bold{Project source code repository}\cr
\url{https://github.com/R-Lum/Luminescence}\cr

\bold{Related package projects}\cr
\url{https://cran.r-project.org/package=RLumShiny}\cr
\url{http://shiny.r-luminescence.org}\cr
\url{https://cran.r-project.org/package=RLumModel}\cr
\url{http://model.r-luminescence.org}\cr

\bold{Package maintainer}

Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne, Pessac,
France, \cr \email{sebastian.kreutzer@u-bordeaux-montaigne.fr}

\bold{Acknowledgement}

Cooperation and personal exchange between the developers is gratefully
funded by the DFG (SCHM 3051/3-1) in the framework of the program
"Scientific Networks". Project title: "RLum.Network: Ein
Wissenschaftsnetzwerk zur Analyse von Lumineszenzdaten mit R" (2014-2017)
}
\keyword{package}
