% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_PSL2R.R
\name{read_PSL2R}
\alias{read_PSL2R}
\title{Import PSL files to R}
\usage{
read_PSL2R(
  file,
  drop_bg = FALSE,
  as_decay_curve = TRUE,
  smooth = FALSE,
  merge = FALSE,
  ...
)
}
\arguments{
\item{file}{\link{character} (\strong{required}):
path and file name of the PSL file. If input is a \code{vector} it should comprise
only \code{character}s representing valid paths and PSL file names.
Alternatively the input character can be just a directory (path). In this case the
the function tries to detect and import all PSL files found in the directory.}

\item{drop_bg}{\link{logical} (\emph{with default}):
\code{TRUE} to automatically remove all non-OSL/IRSL curves.}

\item{as_decay_curve}{\link{logical} (\emph{with default}):
Portable OSL Reader curves are often given as cumulative light sum curves.
Use \code{TRUE} (default) to convert the curves to the more usual decay form.}

\item{smooth}{\link{logical} (\emph{with default}):
\code{TRUE} to apply Tukey's Running Median Smoothing for OSL and IRSL decay curves.
Smoothing is encouraged if you see random signal drops within the decay curves related
to hardware errors.}

\item{merge}{\link{logical} (\emph{with default}):
\code{TRUE} to merge all \code{RLum.Analysis} objects. Only applicable if multiple
files are imported.}

\item{...}{currently not used.}
}
\value{
Returns an S4 \linkS4class{RLum.Analysis} object containing
\linkS4class{RLum.Data.Curve} objects for each curve.
}
\description{
Imports PSL files produced by a SUERC portable OSL reader into R \strong{(BETA)}.
}
\details{
This function provides an import routine for the SUERC portable OSL Reader PSL
format. PSL files are just plain text and can be viewed with any text editor.
Due to the formatting of PSL files this import function relies heavily on
regular expression to find and extract all relevant information. See \strong{note}.
}
\note{
Because this function relies heavily on regular expressions to parse
PSL files it is currently only in beta status. If the routine fails to import
a specific PSL file please report to \verb{<christoph.burow@gmx.net>} so the
function can be updated.
}
\section{Function version}{
 0.0.1
}

\examples{

# (1) Import PSL file to R

file <- system.file("extdata", "DorNie_0016.psl", package = "Luminescence")
psl <- read_PSL2R(file, drop_bg = FALSE, as_decay_curve = TRUE, smooth = TRUE, merge = FALSE)
print(str(psl, max.level = 3))
plot(psl, combine = TRUE)

}
\seealso{
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Curve}
}
\author{
Christoph Burow, University of Cologne (Germany)
, RLum Developer Team} 

\section{How to cite}{
Burow, C., 2021. read_PSL2R(): Import PSL files to R. Function version 0.0.1. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., 2021. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.13. https://CRAN.R-project.org/package=Luminescence
}

\keyword{IO}
