% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_OSLLxTxRatio.R
\name{calc_OSLLxTxRatio}
\alias{calc_OSLLxTxRatio}
\title{Calculate \code{Lx/Tx} ratio for CW-OSL curves}
\usage{
calc_OSLLxTxRatio(
  Lx.data,
  Tx.data = NULL,
  signal.integral,
  signal.integral.Tx = NULL,
  background.integral,
  background.integral.Tx = NULL,
  background.count.distribution = "non-poisson",
  use_previousBG = FALSE,
  sigmab = NULL,
  sig0 = 0,
  digits = NULL
)
}
\arguments{
\item{Lx.data}{\linkS4class{RLum.Data.Curve} or \link{data.frame} (\strong{required}):
requires a CW-OSL shine down curve (x = time, y = counts)}

\item{Tx.data}{\linkS4class{RLum.Data.Curve} or \link{data.frame} (\emph{optional}):
requires a CW-OSL shine down curve (x = time, y = counts). If no
input is given the \code{Tx.data} will be treated as \code{NA} and no \code{Lx/Tx} ratio
is calculated.}

\item{signal.integral}{\link{numeric} (\strong{required}): vector with the limits for the signal integral.
Can be set to \code{NA} than now integrals are considered and all other integrals are set to \code{NA} as well.}

\item{signal.integral.Tx}{\link{numeric} (\emph{optional}):
vector with the limits for the signal integral for the \code{Tx}-curve. If nothing is provided the
value from \code{signal.integral} is used.}

\item{background.integral}{\link{numeric} (\strong{required}):
vector with the bounds for the background integral.
Can be set to \code{NA} than now integrals are considered and all other integrals are set to \code{NA} as well.}

\item{background.integral.Tx}{\link{numeric} (\emph{optional}):
vector with the limits for the background integral for the \code{Tx} curve.
If nothing is provided the value from \code{background.integral} is used.}

\item{background.count.distribution}{\link{character} (\emph{with default}):
sets the count distribution assumed for the error calculation.
Possible arguments \code{poisson} or \code{non-poisson}. See details for further information}

\item{use_previousBG}{\link{logical} (\emph{with default}):
If set to \code{TRUE} the background of the \code{Lx}-signal is subtracted also
from the \code{Tx}-signal. Please note that in this case separate
signal integral limits for the \code{Tx}-signal are not allowed and will be reset.}

\item{sigmab}{\link{numeric} (\emph{optional}):
option to set a manual value for the overdispersion (for \code{LnTx} and \code{TnTx}),
used for the \code{Lx/Tx} error calculation. The value should be provided as
absolute squared count values, e.g. \code{sigmab = c(300,300)}.
\strong{Note:} If only one value is provided this value is taken for both (\code{LnTx} and \code{TnTx}) signals.}

\item{sig0}{\link{numeric} (\emph{with default}):
allow adding an extra component of error to the final \code{Lx/Tx} error value
(e.g., instrumental error, see details).}

\item{digits}{\link{integer} (\emph{with default}):
round numbers to the specified digits.
If digits is set to \code{NULL} nothing is rounded.}
}
\value{
Returns an S4 object of type \linkS4class{RLum.Results}.

Slot \code{data} contains a \link{list} with the following structure:

\strong{@data}\preformatted{$LxTx.table (data.frame)
.. $ LnLx
.. $ LnLx.BG
.. $ TnTx
.. $ TnTx.BG
.. $ Net_LnLx
.. $ Net_LnLx.Error
.. $ Net_TnTx.Error
.. $ LxTx
.. $ LxTx.Error
$ calc.parameters (list)
.. $ sigmab.LnTx
.. $ sigmab.TnTx
.. $ k
}

\strong{@info}\preformatted{$ call (original function call)
}
}
\description{
Calculate \code{Lx/Tx} ratios from a given set of CW-OSL curves assuming late light
background subtraction.
}
\details{
The integrity of the chosen values for the signal and background integral is
checked by the function; the signal integral limits have to be lower than
the background integral limits. If a \link{vector} is given as input instead
of a \link{data.frame}, an artificial \link{data.frame} is produced. The
error calculation is done according to Galbraith (2002).

\strong{Please note:} In cases where the calculation results in \code{NaN} values (for
example due to zero-signal, and therefore a division of 0 by 0), these \code{NaN}
values are replaced by 0.

\strong{\code{sigmab}}

The default value of \code{sigmab} is calculated assuming the background is
constant and \strong{would not} applicable when the background varies as,
e.g., as observed for the early light subtraction method.

\strong{sig0}

This argument allows to add an extra component of error to the final \code{Lx/Tx}
error value. The input will be treated as factor that is multiplied with
the already calculated \code{LxTx} and the result is add up by:

\deqn{se(LxTx) = \sqrt(se(LxTx)^2 + (LxTx * sig0)^2)}

\strong{background.count.distribution}

This argument allows selecting the distribution assumption that is used for
the error calculation. According to Galbraith (2002, 2014) the background
counts may be overdispersed (i.e. do not follow a Poisson distribution,
which is assumed for the photomultiplier counts). In that case (might be the
normal case) it has to be accounted for the overdispersion by estimating
\eqn{\sigma^2} (i.e. the overdispersion value). Therefore the relative
standard error is calculated as:
\itemize{
\item \code{poisson}
\deqn{rse(\mu_{S}) \approx \sqrt(Y_{0} + Y_{1}/k^2)/Y_{0} - Y_{1}/k}
\item \code{non-poisson}
\deqn{rse(\mu_{S}) \approx \sqrt(Y_{0} + Y_{1}/k^2 + \sigma^2(1+1/k))/Y_{0} - Y_{1}/k}
}

\strong{Please note} that when using the early background subtraction method in
combination with the 'non-poisson' distribution argument, the corresponding \code{Lx/Tx} error
may considerably increase due to a high \code{sigmab} value.
Please check whether this is valid for your data set and  if necessary
consider to provide an own \code{sigmab} value using the corresponding argument \code{sigmab}.
}
\note{
The results of this function have been cross-checked with the Analyst
(version 3.24b). Access to the results object via \link{get_RLum}.

\strong{Caution:} If you are using early light subtraction (EBG), please either provide your
own \code{sigmab} value or use \code{background.count.distribution = "poisson"}.
}
\section{Function version}{
 0.8.0
}

\examples{

##load data
data(ExampleData.LxTxOSLData, envir = environment())

##calculate Lx/Tx ratio
results <- calc_OSLLxTxRatio(Lx.data, Tx.data, signal.integral = c(1:2),
                             background.integral = c(85:100))

##get results object
get_RLum(results)

} 

\section{How to cite}{
Kreutzer, S., 2020. calc_OSLLxTxRatio(): Calculate Lx/Tx ratio for CW-OSL curves. Function version 0.8.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Riedesel, S., Autzen, M., Mittelstrass, D., 2020. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.9. https://CRAN.R-project.org/package=Luminescence
}

\references{
Duller, G., 2018. Analyst v4.57 - User Manual.
\url{https://users.aber.ac.uk/ggd/}\cr

Galbraith, R.F., 2002. A note on the variance of a background-corrected OSL
count. Ancient TL, 20 (2), 49-51.

Galbraith, R.F., 2014. A further note on the variance of a
background-corrected OSL count. Ancient TL, 31 (2), 1-3.
}
\seealso{
\linkS4class{RLum.Data.Curve}, \link{Analyse_SAR.OSLdata}, \link{plot_GrowthCurve},
\link{analyse_SAR.CWOSL}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
, RLum Developer Team}
\keyword{datagen}
