% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_RLum.R
\name{smooth_RLum}
\alias{smooth_RLum}
\alias{smooth_RLum,list-method}
\title{Smoothing of data}
\usage{
smooth_RLum(object, ...)

\S4method{smooth_RLum}{list}(object, ...)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum}}

\item{...}{further arguments passed to the specific class method}
}
\value{
An object of the same type as the input object is provided
}
\description{
Function calls the object-specific smooth functions for provided RLum S4-class objects.
}
\details{
The function provides a generalised access point for specific
\linkS4class{RLum} objects.\cr
Depending on the input object, the corresponding function will be selected.
Allowed arguments can be found in the documentations of the corresponding
\linkS4class{RLum} class. The smoothing is based on an internal function
called \code{.smoothing}.
}
\section{Functions}{
\itemize{
\item \code{smooth_RLum,list-method}: Returns a list of \linkS4class{RLum} objects that had been passed to \link{smooth_RLum}
}}

\note{
Currenlty only \code{RLum} objects of class \code{RLum.Data.Curve} and \code{RLum.Analysis}
(with curve data) are supported!
}
\section{Function version}{
 0.1.0
}

\examples{

##load example data
data(ExampleData.CW_OSL_Curve, envir = environment())

##create RLum.Data.Curve object from this example
curve <-
  set_RLum(
      class = "RLum.Data.Curve",
      recordType = "OSL",
      data = as.matrix(ExampleData.CW_OSL_Curve)
  )

##plot data without and with smoothing
plot_RLum(curve)
plot_RLum(smooth_RLum(curve))

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Analysis}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2020. smooth_RLum(): Smoothing of data. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Riedesel, S., Autzen, M., Mittelstrass, D., 2020. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.9. https://CRAN.R-project.org/package=Luminescence
}

\keyword{utilities}
