/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.html.HTMLEditorKit;
import uk.ac.rhul.cs.utils.StringUtils;

public class AboutDialog
extends JDialog
implements ActionListener {
    private boolean constructed = false;

    public AboutDialog(Frame owner, boolean modal) {
        super(owner, "About ClusterONE", modal);
    }

    public AboutDialog(Frame owner) {
        this(owner, true);
    }

    public void actionPerformed(ActionEvent arg0) {
        this.dispose();
    }

    protected void construct() {
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setEditorKit(new HTMLEditorKit());
        editorPane.setBackground(contentPane.getBackground());
        URL logoURL = this.getLogoResourceURL();
        String logoCode = "";
        if (logoURL != null) {
            logoCode = "<center><img src=\"" + logoURL + "\" /></center>";
        }
        String textTemplate = null;
        try {
            InputStream stream = this.getAboutTextResourceAsStream();
            textTemplate = stream != null ? StringUtils.readInputStream(stream) : "";
        }
        catch (IOException ex) {
            textTemplate = "";
        }
        String text = textTemplate.replaceAll("%logo%", logoCode).replaceAll("%appname%", "ClusterONE").replaceAll("%version%", "1.0");
        editorPane.setText(text);
        editorPane.setBackground(Color.white);
        editorPane.setAlignmentX(0.5f);
        editorPane.setMaximumSize(new Dimension(400, Integer.MAX_VALUE));
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("close");
        closeButton.addActionListener(this);
        closeButton.setAlignmentX(0.5f);
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setBackground(Color.white);
        contentPane.setOpaque(true);
        contentPane.add(editorPane);
        contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        contentPane.add(closeButton);
        this.setContentPane(contentPane);
        this.pack();
        this.setSize(420, 320);
        this.constructed = true;
    }

    protected InputStream getAboutTextResourceAsStream() throws IOException {
        return this.getClass().getResourceAsStream("../resources/about_dialog.txt");
    }

    protected URL getLogoResourceURL() {
        return this.getClass().getResource("../resources/logo.png");
    }

    public void setVisible(boolean visible) {
        if (visible && !this.constructed) {
            this.construct();
        }
        super.setVisible(visible);
    }
}

