/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.ObjectMapping;
import giny.model.Node;
import java.awt.Color;
import java.util.List;

public class VisualStyleManager {
    public static final String VISUAL_STYLE_BY_STATUS = "ClusterONE - Status";
    public static final String VISUAL_STYLE_BY_AFFINITY = "ClusterONE - Affinity";

    public static void ensureVizMapperStylesRegistered(boolean recreate) {
        VisualMappingManager visualMappingManager = Cytoscape.getVisualMappingManager();
        if (visualMappingManager == null) {
            return;
        }
        CalculatorCatalog calculatorCatalog = visualMappingManager.getCalculatorCatalog();
        if (calculatorCatalog == null) {
            return;
        }
        VisualStyleManager.ensureVisualStyleByStatusRegistered(calculatorCatalog, recreate);
        VisualStyleManager.ensureVisualStyleByAffinityRegistered(calculatorCatalog, recreate);
    }

    private static void ensureVisualStyleByStatusRegistered(CalculatorCatalog catalog, boolean recreate) {
        VisualStyle defaultStyle;
        if (catalog.getVisualStyleNames().contains(VISUAL_STYLE_BY_STATUS)) {
            if (!recreate) {
                return;
            }
            catalog.removeVisualStyle(VISUAL_STYLE_BY_STATUS);
        }
        if ((defaultStyle = catalog.getVisualStyle("default")) == null) {
            defaultStyle = new VisualStyle("default");
        }
        VisualStyle myStyle = new VisualStyle(defaultStyle, VISUAL_STYLE_BY_STATUS);
        NodeAppearanceCalculator nac = myStyle.getNodeAppearanceCalculator();
        DiscreteMapping colorMapping = new DiscreteMapping((Object)Color.WHITE, "cl1.Status", 1);
        colorMapping.putMapValue((Object)"Outlier", (Object)Color.LIGHT_GRAY);
        colorMapping.putMapValue((Object)"Cluster", (Object)Color.RED);
        colorMapping.putMapValue((Object)"Overlap", (Object)Color.ORANGE);
        BasicCalculator nodeColorCalculator = new BasicCalculator("Vertex color calculator", (ObjectMapping)colorMapping, VisualPropertyType.NODE_FILL_COLOR);
        DiscreteMapping shapeMapping = new DiscreteMapping((Object)NodeShape.RECT, "cl1.Status", 1);
        shapeMapping.putMapValue((Object)"Outlier", (Object)NodeShape.ELLIPSE);
        shapeMapping.putMapValue((Object)"Cluster", (Object)NodeShape.RECT);
        shapeMapping.putMapValue((Object)"Overlap", (Object)NodeShape.DIAMOND);
        BasicCalculator nodeShapeCalculator = new BasicCalculator("Vertex shape calculator", (ObjectMapping)shapeMapping, VisualPropertyType.NODE_SHAPE);
        nac.setCalculator((Calculator)nodeColorCalculator);
        nac.setCalculator((Calculator)nodeShapeCalculator);
        myStyle.setNodeAppearanceCalculator(nac);
        catalog.addVisualStyle(myStyle);
    }

    private static void ensureVisualStyleByAffinityRegistered(CalculatorCatalog catalog, boolean recreate) {
        if (catalog.getVisualStyleNames().contains(VISUAL_STYLE_BY_AFFINITY)) {
            if (!recreate) {
                return;
            }
            catalog.removeVisualStyle(VISUAL_STYLE_BY_AFFINITY);
        }
        CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
        CyNetwork currentNetwork = Cytoscape.getCurrentNetwork();
        double maxAbsValue = 0.0;
        List nodeList = currentNetwork.nodesList();
        for (Node node : nodeList) {
            Object obj = nodeAttrs.getAttribute(node.getIdentifier(), "cl1.Affinity");
            if (obj == null) continue;
            try {
                Double affinity = (Double)obj;
                if (!(Math.abs(affinity) > maxAbsValue)) continue;
                maxAbsValue = Math.abs(affinity);
            }
            catch (ClassCastException ex) {}
        }
        VisualStyle defaultStyle = catalog.getVisualStyle("default");
        if (defaultStyle == null) {
            defaultStyle = new VisualStyle("default");
        }
        VisualStyle myStyle = new VisualStyle(defaultStyle, VISUAL_STYLE_BY_AFFINITY);
        NodeAppearanceCalculator nac = myStyle.getNodeAppearanceCalculator();
        Color minColor = Color.blue;
        Color midColor = Color.white;
        Color maxColor = Color.red;
        ContinuousMapping colorMapping = new ContinuousMapping((Object)Color.WHITE, 1);
        colorMapping.setControllingAttributeName("cl1.Affinity", Cytoscape.getCurrentNetwork(), false);
        colorMapping.setInterpolator((Interpolator)new LinearNumberToColorInterpolator());
        colorMapping.addPoint(-maxAbsValue, new BoundaryRangeValues((Object)minColor, (Object)minColor, (Object)minColor));
        colorMapping.addPoint(0.0, new BoundaryRangeValues((Object)midColor, (Object)midColor, (Object)midColor));
        colorMapping.addPoint(maxAbsValue, new BoundaryRangeValues((Object)maxColor, (Object)maxColor, (Object)maxColor));
        BasicCalculator nodeColorCalculator = new BasicCalculator("Vertex color calculator", (ObjectMapping)colorMapping, VisualPropertyType.NODE_FILL_COLOR);
        DiscreteMapping shapeMapping = new DiscreteMapping((Object)NodeShape.RECT, "cl1.Status", 1);
        shapeMapping.putMapValue((Object)"Outlier", (Object)NodeShape.ELLIPSE);
        shapeMapping.putMapValue((Object)"Cluster", (Object)NodeShape.RECT);
        shapeMapping.putMapValue((Object)"Overlap", (Object)NodeShape.DIAMOND);
        BasicCalculator nodeShapeCalculator = new BasicCalculator("Vertex shape calculator", (ObjectMapping)shapeMapping, VisualPropertyType.NODE_SHAPE);
        nac.setCalculator((Calculator)nodeColorCalculator);
        nac.setCalculator((Calculator)nodeShapeCalculator);
        myStyle.setNodeAppearanceCalculator(nac);
        catalog.addVisualStyle(myStyle);
    }

    public static void updateAffinityStyleRange() {
    }
}

