/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import uk.ac.rhul.cs.graph.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueIDGenerator<K> {
    protected Map<K, Integer> map = new HashMap<K, Integer>();
    protected Graph graph = null;

    public UniqueIDGenerator(Graph graph) {
        this.graph = graph;
    }

    public int get(K name) {
        Integer result = this.map.get(name);
        if (result == null) {
            result = this.graph.createNode(name.toString());
            this.map.put(name, result);
        }
        return result;
    }

    public int getStrict(K name) {
        Integer result = this.map.get(name);
        if (result == null) {
            throw new IllegalStateException("key not found: " + name.toString());
        }
        return result;
    }

    public Map<K, Integer> toMap() {
        TreeMap<K, Integer> result = new TreeMap<K, Integer>(this.map);
        return result;
    }

    public Map<Integer, K> getReversedMap() {
        TreeMap<Integer, K> result = new TreeMap<Integer, K>();
        for (Map.Entry<K, Integer> entry : this.map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public List<K> getReversedList() {
        ArrayList<K> result = new ArrayList<K>(this.map.size());
        for (int i = 0; i < this.map.size(); ++i) {
            result.add(null);
        }
        for (Map.Entry<K, Integer> entry : this.map.entrySet()) {
            result.set(entry.getValue(), entry.getKey());
        }
        return result;
    }
}

