% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMzShift.R
\name{getMzShift}
\alias{getMzShift}
\title{Get mass shift for target mz}
\usage{
getMzShift(peaks, targetMz, tol, tolppm = FALSE, verbose = TRUE)
}
\arguments{
\item{peaks}{List of MALDIquant::MassPeak}

\item{targetMz}{Numeric, target mass}

\item{tol}{Numeric, tolerance around targetMz}

\item{tolppm}{Logical, tolerance supplied in ppm}

\item{verbose}{Logical, print logs to the console.}
}
\value{
List with two entries:
\code{MzShift} The mass shift for each spectrum
\code{specIdx} The index of the spectra with a match for targetMz
}
\description{
Get mass shift for target mz
}
\examples{
data(Blank2022peaks)
getMzShift(Blank2022peaks, targetMz = 760.585, tol = 0.1, tolppm = FALSE)
}
