% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{EEGwide}
\alias{EEGwide}
\title{EEG Measurements in Patients with Alzheimer's Disease (wide format)}
\format{
A data frame with 160 rows and 9 variables:
\describe{
  \item{brainrate_temporal}{EEG measurements for brainrate in temporal regions}
  \item{brainrate_frontal}{EEG measurements for brainrate in frontal regions}
  \item{brainrate_central}{EEG measurements for brainrate in central regions}
  \item{complexity_temporal}{EEG measurements for complexity in temporal regions}
  \item{complexity_frontal}{EEG measurements for complexity in frontal regions}
  \item{complexity_central}{EEG measurements for complexity in central regions}
  \item{sex}{sex of the patient}
  \item{age}{age of the patient}
  \item{diagnosis}{neuropsychological diagnosis, AD for Alzheimer's Disease, MCI for mild cognitive impairment or SCC for subjective cognitive complaints without clinically significant deficits}
  \item{AgeGroup}{categorized age, coded as 0 for less than 70 years and 1 for \eqn{>= 70} years}
}
}
\source{
Bathke, A., Friedrich, S., Konietschke, F., Pauly, M., Staffen, W., Strobl, N. and 
  Hoeller, Y. (2018). Testing Mean Differences among Groups: Multivariate and Repeated 
  Measures Analysis with Minimal Assumptions. Multivariate Behavioral Research. 
  Doi: 10.1080/00273171.2018.1446320.
  
  
  @examples 
  library("ggplot2")
  qplot(data = EEGwide, diagnosis)
}
\usage{
data(EEGwide)
}
\description{
At the Department of Neurology, University Clinic of Salzburg, 160 patients were diagnosed
with either AD, MCI, or SCC, based on neuropsychological diagnostics. This data set contains z-scores for brain rate and Hjorth complexity,
each measured at frontal, temporal and central electrode positions and averaged across hemispheres. In addition to standardization, complexity
values were multiplied by -1 in order to make them more easily comparable to brain rate
values: For brain rate we know that the values decrease with age and pathology, while
Hjorth complexity values are known to increase with age and pathology.
The three between-subjects factors considered were sex (men vs. women), diagnosis (AD
vs. MCI vs. SCC), and age (\eqn{< 70} vs. \eqn{>= 70} years). Additionally, the within-subjects factors region (frontal, temporal, central) and 
feature (brain rate, complexity) structure the response vector.
}
\details{
Note that this data set contains exactly the same data as the data set 'EEG', only the format is different. The 
transformation between the different formats can be achieved using, e.g., the \code{tidyr} package.
}
\keyword{datasets}
