% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_03_4_CompareValues_IsoSwitch.R
\name{IsoSwitch}
\alias{IsoSwitch}
\title{Detect Isoform Switch}
\usage{
IsoSwitch(MarvelObject, psi.de.sig, cell.types, method, method.adjust,
  gene.de.sig)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CompareValues} function.}

\item{psi.de.sig}{Numeric value. Adjusted p-value below which the splicing event is considered differentially spliced and included for isoform switching analysis.}

\item{cell.types}{Character string. To indicate which 2 groups of cells that will be used for differential splicing analysis. Group names should match those in \code{cell.type} column of \code{$SplicePheno} slot.}

\item{method}{Character string. Statistical test for differential gene expression analysis. Can take values \code{"ks"}, \code{"wilcox"} or \code{"t.test"}. Please refer to \code{CompareValues} function for more details.}

\item{method.adjust}{Character strings. Adjust for multiple testing as per \code{p.adjust} function.}

\item{gene.de.sig}{Numeric value. Adjusted p-value below which the gene is considered differentially expressed.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to three new slots named \code{$DE$Cor*}. \code{$DE$Cor} Original data frame generated from \code{CompareValues} function with an additional column to indicate if isoform switching has taken place. \code{$DE$CorProp} Tabulated proportion for each PSI-gene expression relationship. \code{$DE$CorPlot} Doughnut plot representing the values in \code{$DE$CorProp}.
}
\description{
\code{IsoSwitch} compare changes in PSI values with corresponding gene expression values to detect genes that have undergone isoform switching.
}
\details{
This function compare changes in PSI values with corresponding gene expression values to detect genes that have undergone isoform switching. Isoform switch occurs when there is significant change in PSI values between 2 groups of cells in the absence of any significant change in gene expression values. This function also detect PSI values that change in the same or opposite direction with gene expression values.
}
\examples{
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

marvel <- IsoSwitch(MarvelObject=marvel,
                    psi.de.sig=0.05,
                    cell.types=c("iPSC", "Endoderm"),
                    method="t.test",
                    method.adjust="fdr",
                    gene.de.sig=0.05
                    )

marvel$DE$Cor[1:5, ]
marvel$DE$CorPlot
marvel$DE$CorProp
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
