% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_08_DE_2_1_PlotDEValues_PSI_Distance.R
\name{PlotDEValues.PSI.Distance}
\alias{PlotDEValues.PSI.Distance}
\title{Plot differential splicing analysis results based on distance statistics.}
\usage{
PlotDEValues.PSI.Distance(
  MarvelObject,
  method,
  pval,
  point.size = 1,
  xlabel.size = 8,
  anno = FALSE,
  anno.tran_id = NULL,
  label.size = 2.5,
  y.upper.offset = 5
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CompareValues} function.}

\item{method}{Character string. The statistical method used for differential splicing analysis.}

\item{pval}{Numeric value. Adjusted p-value below which the splcing events are considered as statistically significant and will consequently be color-annotated on the plot.}

\item{point.size}{Numeric value. The point size for the data points. Default value is \code{1}.}

\item{xlabel.size}{Numeric value. Font size of the xtick labels. Default is \code{8}.}

\item{anno}{Logical value. If set to \code{TRUE}, the specific gene names will be annotated on the plot. Speficified together with \code{anno.tran_id}.}

\item{anno.tran_id}{Vector of character strings. When \code{anno} set to \code{TRUE}, the coordinates of the splicing events to be annotated on the plot.}

\item{label.size}{Numeric value. Only applicable if \code{anno} set to TRUE. Size of the gene name labels.}

\item{y.upper.offset}{Numeric value. The value in -log10(p-value) to increase the upper limit of the y-axis. To be used when \code{anno} set to TRUE so that gene labels will not be truncated at the upper limit of the y-axis.}
}
\value{
An object of class S3 containing with new slot \code{MarvelObject$DE$PSI$Plot[["method"]]}.
}
\description{
Ranked plot for differential splicing analysis results based on distance statistics. Only statistical test that assess the overall PSI distribution between two cell groups will be eligible for plotting here, e.g., Anderson-Darling and DTS. x-axis represents the distance statistics. y-axis represents the adjusted p-values.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- PlotDEValues.PSI.Distance(MarvelObject=marvel.demo,
                                         method="ad",
                                         pval=0.10
                                         )

# Check output
marvel.demo$DE$PSI$Plot[["ad"]]
}
